/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.sticker;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.View;
import me.kareluo.imaging.core.sticker.IMGStickerPortrait;

public class IMGStickerHelper<StickerView extends View>
implements IMGStickerPortrait,
IMGStickerPortrait.Callback {
    private RectF mFrame;
    private StickerView mView;
    private IMGStickerPortrait.Callback mCallback;
    private boolean isShowing = false;

    public IMGStickerHelper(StickerView view) {
        this.mView = view;
    }

    @Override
    public boolean show() {
        if (!this.isShowing()) {
            this.isShowing = true;
            this.onShowing((View)this.mView);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove() {
        return this.onRemove((View)this.mView);
    }

    @Override
    public boolean dismiss() {
        if (this.isShowing()) {
            this.isShowing = false;
            this.onDismiss((View)this.mView);
            return true;
        }
        return false;
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    public RectF getFrame() {
        if (this.mFrame == null) {
            this.mFrame = new RectF(0.0f, 0.0f, (float)this.mView.getWidth(), (float)this.mView.getHeight());
            float pivotX = this.mView.getX() + this.mView.getPivotX();
            float pivotY = this.mView.getY() + this.mView.getPivotY();
            Matrix matrix = new Matrix();
            matrix.setTranslate(this.mView.getX(), this.mView.getY());
            matrix.postScale(this.mView.getScaleX(), this.mView.getScaleY(), pivotX, pivotY);
            matrix.mapRect(this.mFrame);
        }
        return this.mFrame;
    }

    @Override
    public void onSticker(Canvas canvas) {
    }

    @Override
    public void registerCallback(IMGStickerPortrait.Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void unregisterCallback(IMGStickerPortrait.Callback callback) {
        this.mCallback = null;
    }

    @Override
    public <V extends View> boolean onRemove(V stickerView) {
        return this.mCallback != null && this.mCallback.onRemove(stickerView);
    }

    @Override
    public <V extends View> void onDismiss(V stickerView) {
        this.mFrame = null;
        stickerView.invalidate();
        if (this.mCallback != null) {
            this.mCallback.onDismiss(stickerView);
        }
    }

    @Override
    public <V extends View> void onShowing(V stickerView) {
        stickerView.invalidate();
        if (this.mCallback != null) {
            this.mCallback.onShowing(stickerView);
        }
    }
}

