/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.sticker;

import android.graphics.Matrix;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import me.kareluo.imaging.view.IMGStickerView;

public class IMGStickerAdjustHelper
implements View.OnTouchListener {
    private static final String TAG = "IMGStickerAdjustHelper";
    private View mView;
    private IMGStickerView mContainer;
    private float mCenterX;
    private float mCenterY;
    private double mRadius;
    private double mDegrees;
    private Matrix M = new Matrix();

    public IMGStickerAdjustHelper(IMGStickerView container, View view) {
        this.mView = view;
        this.mContainer = container;
        this.mView.setOnTouchListener((View.OnTouchListener)this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                float x = event.getX();
                float y = event.getY();
                this.mCenterY = 0.0f;
                this.mCenterX = 0.0f;
                float pointX = this.mView.getX() + x - this.mContainer.getPivotX();
                float pointY = this.mView.getY() + y - this.mContainer.getPivotY();
                Log.d((String)TAG, (String)String.format("X=%f,Y=%f", Float.valueOf(pointX), Float.valueOf(pointY)));
                this.mRadius = IMGStickerAdjustHelper.toLength(0.0f, 0.0f, pointX, pointY);
                this.mDegrees = IMGStickerAdjustHelper.toDegrees(pointY, pointX);
                this.M.setTranslate(pointX - x, pointY - y);
                Log.d((String)TAG, (String)String.format("degrees=%f", IMGStickerAdjustHelper.toDegrees(pointY, pointX)));
                this.M.postRotate((float)(-IMGStickerAdjustHelper.toDegrees(pointY, pointX)), this.mCenterX, this.mCenterY);
                return true;
            }
            case 2: {
                float[] xy = new float[]{event.getX(), event.getY()};
                float pointX = this.mView.getX() + xy[0] - this.mContainer.getPivotX();
                float pointY = this.mView.getY() + xy[1] - this.mContainer.getPivotY();
                Log.d((String)TAG, (String)String.format("X=%f,Y=%f", Float.valueOf(pointX), Float.valueOf(pointY)));
                double radius = IMGStickerAdjustHelper.toLength(0.0f, 0.0f, pointX, pointY);
                double degrees = IMGStickerAdjustHelper.toDegrees(pointY, pointX);
                float scale = (float)(radius / this.mRadius);
                this.mContainer.addScale(scale);
                Log.d((String)TAG, (String)("    D   = " + (degrees - this.mDegrees)));
                this.mContainer.setRotation((float)((double)this.mContainer.getRotation() + degrees - this.mDegrees));
                this.mRadius = radius;
                return true;
            }
        }
        return false;
    }

    private static double toDegrees(float v, float v1) {
        return Math.toDegrees(Math.atan2(v, v1));
    }

    private static double toLength(float x1, float y1, float x2, float y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
}

