/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.elastic;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.animation.AccelerateDecelerateInterpolator;
import me.kareluo.imaging.core.elastic.IMGElastic;
import me.kareluo.imaging.core.elastic.IMGPointFEvaluator;

public class IMGElasticAnimator
extends ValueAnimator {
    private IMGElastic mElastic;

    public IMGElasticAnimator() {
        this.setEvaluator(new IMGPointFEvaluator());
        this.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
    }

    public IMGElasticAnimator(IMGElastic elastic) {
        this();
        this.setElastic(elastic);
    }

    public void setElastic(IMGElastic elastic) {
        this.mElastic = elastic;
        if (this.mElastic == null) {
            throw new IllegalArgumentException("IMGElastic cannot be null.");
        }
    }

    public void start(float x, float y) {
        this.setObjectValues(new Object[]{new PointF(x, y), this.mElastic.getPivot()});
        this.start();
    }
}

