/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.clip;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import me.kareluo.imaging.core.clip.IMGClip;
import me.kareluo.imaging.core.util.IMGUtils;

public class IMGClipWindow
implements IMGClip {
    private RectF mFrame = new RectF();
    private RectF mBaseFrame = new RectF();
    private RectF mTargetFrame = new RectF();
    private RectF mWinFrame = new RectF();
    private RectF mWin = new RectF();
    private float[] mCells = new float[16];
    private float[] mCorners = new float[32];
    private float[][] mBaseSizes = new float[2][4];
    private boolean isClipping = false;
    private boolean isResetting = true;
    private boolean isShowShade = false;
    private boolean isHoming = false;
    private Matrix M = new Matrix();
    private Path mShadePath = new Path();
    private Paint mPaint = new Paint(1);
    private static final float VERTICAL_RATIO = 0.8f;
    private static final int COLOR_CELL = -2130706433;
    private static final int COLOR_FRAME = -1;
    private static final int COLOR_CORNER = -1;
    private static final int COLOR_SHADE = -872415232;

    public IMGClipWindow() {
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
    }

    public void setClipWinSize(float width, float height) {
        this.mWin.set(0.0f, 0.0f, width, height);
        this.mWinFrame.set(0.0f, 0.0f, width, height * 0.8f);
        if (!this.mFrame.isEmpty()) {
            IMGUtils.center(this.mWinFrame, this.mFrame);
            this.mTargetFrame.set(this.mFrame);
        }
    }

    public void reset(RectF clipImage, float rotate) {
        RectF imgRect = new RectF();
        this.M.setRotate(rotate, clipImage.centerX(), clipImage.centerY());
        this.M.mapRect(imgRect, clipImage);
        this.reset(imgRect.width(), imgRect.height());
    }

    private void reset(float clipWidth, float clipHeight) {
        this.setResetting(true);
        this.mFrame.set(0.0f, 0.0f, clipWidth, clipHeight);
        IMGUtils.fitCenter(this.mWinFrame, this.mFrame, 60.0f);
        this.mTargetFrame.set(this.mFrame);
    }

    public boolean homing() {
        this.mBaseFrame.set(this.mFrame);
        this.mTargetFrame.set(this.mFrame);
        IMGUtils.fitCenter(this.mWinFrame, this.mTargetFrame, 60.0f);
        this.isHoming = !this.mTargetFrame.equals((Object)this.mBaseFrame);
        return this.isHoming;
    }

    public void homing(float fraction) {
        if (this.isHoming) {
            this.mFrame.set(this.mBaseFrame.left + (this.mTargetFrame.left - this.mBaseFrame.left) * fraction, this.mBaseFrame.top + (this.mTargetFrame.top - this.mBaseFrame.top) * fraction, this.mBaseFrame.right + (this.mTargetFrame.right - this.mBaseFrame.right) * fraction, this.mBaseFrame.bottom + (this.mTargetFrame.bottom - this.mBaseFrame.bottom) * fraction);
        }
    }

    public boolean isHoming() {
        return this.isHoming;
    }

    public void setHoming(boolean homing) {
        this.isHoming = homing;
    }

    public boolean isClipping() {
        return this.isClipping;
    }

    public void setClipping(boolean clipping) {
        this.isClipping = clipping;
    }

    public boolean isResetting() {
        return this.isResetting;
    }

    public void setResetting(boolean resetting) {
        this.isResetting = resetting;
    }

    public RectF getFrame() {
        return this.mFrame;
    }

    public RectF getWinFrame() {
        return this.mWinFrame;
    }

    public RectF getOffsetFrame(float offsetX, float offsetY) {
        RectF frame = new RectF(this.mFrame);
        frame.offset(offsetX, offsetY);
        return frame;
    }

    public RectF getTargetFrame() {
        return this.mTargetFrame;
    }

    public RectF getOffsetTargetFrame(float offsetX, float offsetY) {
        RectF targetFrame = new RectF(this.mFrame);
        targetFrame.offset(offsetX, offsetY);
        return targetFrame;
    }

    public boolean isShowShade() {
        return this.isShowShade;
    }

    public void setShowShade(boolean showShade) {
        this.isShowShade = showShade;
    }

    public void onDraw(Canvas canvas) {
        int i;
        if (this.isResetting) {
            return;
        }
        float[] size = new float[]{this.mFrame.width(), this.mFrame.height()};
        for (i = 0; i < this.mBaseSizes.length; ++i) {
            for (int j = 0; j < this.mBaseSizes[i].length; ++j) {
                this.mBaseSizes[i][j] = size[i] * CLIP_SIZE_RATIO[j];
            }
        }
        for (i = 0; i < this.mCells.length; ++i) {
            this.mCells[i] = this.mBaseSizes[i & 1][1935858840 >>> (i << 1) & 3];
        }
        for (i = 0; i < this.mCorners.length; ++i) {
            this.mCorners[i] = this.mBaseSizes[i & 1][179303760 >>> i & 1] + CLIP_CORNER_SIZES[CLIP_CORNERS[i] & 3] + CLIP_CORNER_STEPS[CLIP_CORNERS[i] >> 2];
        }
        canvas.translate(this.mFrame.left, this.mFrame.top);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-2130706433);
        this.mPaint.setStrokeWidth(3.0f);
        canvas.drawLines(this.mCells, this.mPaint);
        canvas.translate(-this.mFrame.left, -this.mFrame.top);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(8.0f);
        canvas.drawRect(this.mFrame, this.mPaint);
        canvas.translate(this.mFrame.left, this.mFrame.top);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(14.0f);
        canvas.drawLines(this.mCorners, this.mPaint);
    }

    public void onDrawShade(Canvas canvas) {
        if (!this.isShowShade) {
            return;
        }
        this.mShadePath.reset();
        this.mShadePath.setFillType(Path.FillType.WINDING);
        this.mShadePath.addRect(this.mFrame.left + 100.0f, this.mFrame.top + 100.0f, this.mFrame.right - 100.0f, this.mFrame.bottom - 100.0f, Path.Direction.CW);
        this.mPaint.setColor(-872415232);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mShadePath, this.mPaint);
    }

    public IMGClip.Anchor getAnchor(float x, float y) {
        if (IMGClip.Anchor.isCohesionContains(this.mFrame, -48.0f, x, y) && !IMGClip.Anchor.isCohesionContains(this.mFrame, 48.0f, x, y)) {
            int v = 0;
            float[] cohesion = IMGClip.Anchor.cohesion(this.mFrame, 0.0f);
            float[] pos = new float[]{x, y};
            for (int i = 0; i < cohesion.length; ++i) {
                if (!(Math.abs(cohesion[i] - pos[i >> 1]) < 48.0f)) continue;
                v |= 1 << i;
            }
            IMGClip.Anchor anchor = IMGClip.Anchor.valueOf(v);
            if (anchor != null) {
                this.isHoming = false;
            }
            return anchor;
        }
        return null;
    }

    public void onScroll(IMGClip.Anchor anchor, float dx, float dy) {
        anchor.move(this.mWinFrame, this.mFrame, dx, dy);
    }
}

