/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core.clip;

import android.graphics.RectF;

public interface IMGClip {
    public static final float CLIP_MARGIN = 60.0f;
    public static final float CLIP_CORNER_SIZE = 48.0f;
    public static final float CLIP_FRAME_MIN = 150.72f;
    public static final float CLIP_THICKNESS_CELL = 3.0f;
    public static final float CLIP_THICKNESS_FRAME = 8.0f;
    public static final float CLIP_THICKNESS_SEWING = 14.0f;
    public static final float[] CLIP_SIZE_RATIO = new float[]{0.0f, 1.0f, 0.33f, 0.66f};
    public static final int CLIP_CELL_STRIDES = 1935858840;
    public static final int CLIP_CORNER_STRIDES = 179303760;
    public static final float[] CLIP_CORNER_STEPS = new float[]{0.0f, 3.0f, -3.0f};
    public static final float[] CLIP_CORNER_SIZES = new float[]{0.0f, 48.0f, -48.0f};
    public static final byte[] CLIP_CORNERS = new byte[]{8, 8, 9, 8, 6, 8, 4, 8, 4, 8, 4, 1, 4, 10, 4, 8, 4, 4, 6, 4, 9, 4, 8, 4, 8, 4, 8, 6, 8, 9, 8, 8};

    public static enum Anchor {
        LEFT(1),
        RIGHT(2),
        TOP(4),
        BOTTOM(8),
        LEFT_TOP(5),
        RIGHT_TOP(6),
        LEFT_BOTTOM(9),
        RIGHT_BOTTOM(10);

        int v;
        static final int P = 0;
        static final int N = 1;
        static final int H = 0;
        static final int V = 2;
        static final int[] PN;

        private Anchor(int v) {
            this.v = v;
        }

        public void move(RectF win, RectF frame, float dx, float dy) {
            float[] maxFrame = Anchor.cohesion(win, 60.0f);
            float[] minFrame = Anchor.cohesion(frame, 150.72f);
            float[] theFrame = Anchor.cohesion(frame, 0.0f);
            float[] dxy = new float[]{dx, 0.0f, dy};
            for (int i = 0; i < 4; ++i) {
                if ((1 << i & this.v) == 0) continue;
                int pn = PN[i & 1];
                theFrame[i] = (float)pn * Anchor.revise((float)pn * (theFrame[i] + dxy[i & 2]), (float)pn * maxFrame[i], (float)pn * minFrame[i + PN[i & 1]]);
            }
            frame.set(theFrame[0], theFrame[2], theFrame[1], theFrame[3]);
        }

        public static float revise(float v, float min, float max) {
            return Math.min(Math.max(v, min), max);
        }

        public static float[] cohesion(RectF win, float v) {
            return new float[]{win.left + v, win.right - v, win.top + v, win.bottom - v};
        }

        public static boolean isCohesionContains(RectF frame, float v, float x, float y) {
            return frame.left + v < x && frame.right - v > x && frame.top + v < y && frame.bottom - v > y;
        }

        public static Anchor valueOf(int v) {
            Anchor[] values;
            for (Anchor anchor : values = Anchor.values()) {
                if (anchor.v != v) continue;
                return anchor;
            }
            return null;
        }

        static {
            PN = new int[]{1, -1};
        }
    }
}

