/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import me.kareluo.imaging.core.IMGMode;

public class IMGPath {
    protected Path path;
    private int color = -65536;
    private float width = 72.0f;
    private IMGMode mode = IMGMode.DOODLE;
    public static final float BASE_DOODLE_WIDTH = 20.0f;
    public static final float BASE_MOSAIC_WIDTH = 72.0f;

    public IMGPath() {
        this(new Path());
    }

    public IMGPath(Path path) {
        this(path, IMGMode.DOODLE);
    }

    public IMGPath(Path path, IMGMode mode) {
        this(path, mode, -65536);
    }

    public IMGPath(Path path, IMGMode mode, int color) {
        this(path, mode, color, 72.0f);
    }

    public IMGPath(Path path, IMGMode mode, int color, float width) {
        this.path = path;
        this.mode = mode;
        this.color = color;
        this.width = width;
        if (mode == IMGMode.MOSAIC) {
            path.setFillType(Path.FillType.EVEN_ODD);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public IMGMode getMode() {
        return this.mode;
    }

    public void setMode(IMGMode mode) {
        this.mode = mode;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return this.width;
    }

    public void onDrawDoodle(Canvas canvas, Paint paint) {
        if (this.mode == IMGMode.DOODLE) {
            paint.setColor(this.color);
            paint.setStrokeWidth(20.0f);
            canvas.drawPath(this.path, paint);
        }
    }

    public void onDrawMosaic(Canvas canvas, Paint paint) {
        if (this.mode == IMGMode.MOSAIC) {
            paint.setStrokeWidth(this.width);
            canvas.drawPath(this.path, paint);
        }
    }

    public void transform(Matrix matrix) {
        this.path.transform(matrix);
    }
}

