/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import me.kareluo.imaging.core.IMGMode;
import me.kareluo.imaging.core.IMGPath;
import me.kareluo.imaging.core.clip.IMGClip;
import me.kareluo.imaging.core.clip.IMGClipWindow;
import me.kareluo.imaging.core.homing.IMGHoming;
import me.kareluo.imaging.core.sticker.IMGSticker;
import me.kareluo.imaging.core.util.IMGUtils;

public class IMGImage {
    private static final String TAG = "IMGImage";
    private Bitmap mImage;
    private Bitmap mMosaicImage;
    private RectF mFrame = new RectF();
    private RectF mClipFrame = new RectF();
    private RectF mTempClipFrame = new RectF();
    private RectF mBackupClipFrame = new RectF();
    private float mBackupClipRotate = 0.0f;
    private float mRotate = 0.0f;
    private float mTargetRotate = 0.0f;
    private boolean isRequestToBaseFitting = false;
    private boolean isAnimCanceled = false;
    private IMGClip.Anchor mAnchor;
    private boolean isSteady = true;
    private Path mShade = new Path();
    private IMGClipWindow mClipWin = new IMGClipWindow();
    private boolean isDrawClip = false;
    private IMGMode mMode = IMGMode.NONE;
    private boolean isFreezing = this.mMode == IMGMode.CLIP;
    private RectF mWindow = new RectF();
    private boolean isInitialHoming = false;
    private IMGSticker mForeSticker;
    private List<IMGSticker> mBackStickers = new ArrayList<IMGSticker>();
    private List<IMGPath> mDoodles = new ArrayList<IMGPath>();
    private List<IMGPath> mMosaics = new ArrayList<IMGPath>();
    private static final int MIN_SIZE = 500;
    private static final int MAX_SIZE = 10000;
    private Paint mPaint;
    private Paint mMosaicPaint;
    private Paint mShadePaint;
    private Matrix M = new Matrix();
    private static final boolean DEBUG = false;
    private static final Bitmap DEFAULT_IMAGE = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    private static final int COLOR_SHADE = -872415232;

    public IMGImage() {
        this.mShade.setFillType(Path.FillType.WINDING);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(20.0f);
        this.mPaint.setColor(-65536);
        this.mPaint.setPathEffect((PathEffect)new CornerPathEffect(20.0f));
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mImage = DEFAULT_IMAGE;
        if (this.mMode == IMGMode.CLIP) {
            this.initShadePaint();
        }
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.mImage = bitmap;
        if (this.mMosaicImage != null) {
            this.mMosaicImage.recycle();
        }
        this.mMosaicImage = null;
        this.makeMosaicBitmap();
        this.onImageChanged();
    }

    public IMGMode getMode() {
        return this.mMode;
    }

    public void setMode(IMGMode mode) {
        if (this.mMode == mode) {
            return;
        }
        this.moveToBackground(this.mForeSticker);
        if (mode == IMGMode.CLIP) {
            this.setFreezing(true);
        }
        this.mMode = mode;
        if (this.mMode == IMGMode.CLIP) {
            this.initShadePaint();
            this.mBackupClipRotate = this.getRotate();
            this.mBackupClipFrame.set(this.mClipFrame);
            float scale = 1.0f / this.getScale();
            this.M.setTranslate(-this.mFrame.left, -this.mFrame.top);
            this.M.postScale(scale, scale);
            this.M.mapRect(this.mBackupClipFrame);
            this.mClipWin.reset(this.mClipFrame, this.getTargetRotate());
        } else {
            if (this.mMode == IMGMode.MOSAIC) {
                this.makeMosaicBitmap();
            }
            this.mClipWin.setClipping(false);
        }
    }

    private void rotateStickers(float rotate) {
        this.M.setRotate(rotate, this.mClipFrame.centerX(), this.mClipFrame.centerY());
        for (IMGSticker sticker : this.mBackStickers) {
            this.M.mapRect(sticker.getFrame());
            sticker.setRotation(sticker.getRotation() + rotate);
            sticker.setX(sticker.getFrame().centerX() - sticker.getPivotX());
            sticker.setY(sticker.getFrame().centerY() - sticker.getPivotY());
        }
    }

    private void initShadePaint() {
        if (this.mShadePaint == null) {
            this.mShadePaint = new Paint(1);
            this.mShadePaint.setColor(-872415232);
            this.mShadePaint.setStyle(Paint.Style.FILL);
        }
    }

    public boolean isMosaicEmpty() {
        return this.mMosaics.isEmpty();
    }

    public boolean isDoodleEmpty() {
        return this.mDoodles.isEmpty();
    }

    public void undoDoodle() {
        if (!this.mDoodles.isEmpty()) {
            this.mDoodles.remove(this.mDoodles.size() - 1);
        }
    }

    public void undoMosaic() {
        if (!this.mMosaics.isEmpty()) {
            this.mMosaics.remove(this.mMosaics.size() - 1);
        }
    }

    public RectF getClipFrame() {
        return this.mClipFrame;
    }

    public IMGHoming clip(float scrollX, float scrollY) {
        RectF frame = this.mClipWin.getOffsetFrame(scrollX, scrollY);
        this.M.setRotate(-this.getRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
        this.M.mapRect(this.mClipFrame, frame);
        return new IMGHoming(scrollX + (this.mClipFrame.centerX() - frame.centerX()), scrollY + (this.mClipFrame.centerY() - frame.centerY()), this.getScale(), this.getRotate());
    }

    public void toBackupClip() {
        this.M.setScale(this.getScale(), this.getScale());
        this.M.postTranslate(this.mFrame.left, this.mFrame.top);
        this.M.mapRect(this.mClipFrame, this.mBackupClipFrame);
        this.setTargetRotate(this.mBackupClipRotate);
        this.isRequestToBaseFitting = true;
    }

    public void resetClip() {
        this.setTargetRotate(this.getRotate() - this.getRotate() % 360.0f);
        this.mClipFrame.set(this.mFrame);
        this.mClipWin.reset(this.mClipFrame, this.getTargetRotate());
    }

    private void makeMosaicBitmap() {
        if (this.mMosaicImage != null || this.mImage == null) {
            return;
        }
        if (this.mMode == IMGMode.MOSAIC) {
            int w = Math.round((float)this.mImage.getWidth() / 64.0f);
            int h = Math.round((float)this.mImage.getHeight() / 64.0f);
            w = Math.max(w, 8);
            h = Math.max(h, 8);
            if (this.mMosaicPaint == null) {
                this.mMosaicPaint = new Paint(1);
                this.mMosaicPaint.setFilterBitmap(false);
                this.mMosaicPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            }
            this.mMosaicImage = Bitmap.createScaledBitmap((Bitmap)this.mImage, (int)w, (int)h, (boolean)false);
        }
    }

    private void onImageChanged() {
        this.isInitialHoming = false;
        this.onWindowChanged(this.mWindow.width(), this.mWindow.height());
        if (this.mMode == IMGMode.CLIP) {
            this.mClipWin.reset(this.mClipFrame, this.getTargetRotate());
        }
    }

    public RectF getFrame() {
        return this.mFrame;
    }

    public boolean onClipHoming() {
        return this.mClipWin.homing();
    }

    public IMGHoming getStartHoming(float scrollX, float scrollY) {
        return new IMGHoming(scrollX, scrollY, this.getScale(), this.getRotate());
    }

    public IMGHoming getEndHoming(float scrollX, float scrollY) {
        IMGHoming homing = new IMGHoming(scrollX, scrollY, this.getScale(), this.getTargetRotate());
        if (this.mMode == IMGMode.CLIP) {
            RectF frame = new RectF(this.mClipWin.getTargetFrame());
            frame.offset(scrollX, scrollY);
            if (this.mClipWin.isResetting()) {
                RectF clipFrame = new RectF();
                this.M.setRotate(this.getTargetRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
                this.M.mapRect(clipFrame, this.mClipFrame);
                homing.rConcat(IMGUtils.fill(frame, clipFrame));
            } else {
                RectF cFrame = new RectF();
                if (this.mClipWin.isHoming()) {
                    this.M.setRotate(this.getTargetRotate() - this.getRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
                    this.M.mapRect(cFrame, this.mClipWin.getOffsetFrame(scrollX, scrollY));
                    homing.rConcat(IMGUtils.fitHoming(frame, cFrame, this.mClipFrame.centerX(), this.mClipFrame.centerY()));
                } else {
                    this.M.setRotate(this.getTargetRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
                    this.M.mapRect(cFrame, this.mFrame);
                    homing.rConcat(IMGUtils.fillHoming(frame, cFrame, this.mClipFrame.centerX(), this.mClipFrame.centerY()));
                }
            }
        } else {
            RectF clipFrame = new RectF();
            this.M.setRotate(this.getTargetRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
            this.M.mapRect(clipFrame, this.mClipFrame);
            RectF win = new RectF(this.mWindow);
            win.offset(scrollX, scrollY);
            homing.rConcat(IMGUtils.fitHoming(win, clipFrame, this.isRequestToBaseFitting));
            this.isRequestToBaseFitting = false;
        }
        return homing;
    }

    public <S extends IMGSticker> void addSticker(S sticker) {
        if (sticker != null) {
            this.moveToForeground(sticker);
        }
    }

    public void addPath(IMGPath path, float sx, float sy) {
        if (path == null) {
            return;
        }
        float scale = 1.0f / this.getScale();
        this.M.setTranslate(sx, sy);
        this.M.postRotate(-this.getRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
        this.M.postTranslate(-this.mFrame.left, -this.mFrame.top);
        this.M.postScale(scale, scale);
        path.transform(this.M);
        switch (path.getMode()) {
            case DOODLE: {
                this.mDoodles.add(path);
                break;
            }
            case MOSAIC: {
                path.setWidth(path.getWidth() * scale);
                this.mMosaics.add(path);
            }
        }
    }

    private void moveToForeground(IMGSticker sticker) {
        if (sticker == null) {
            return;
        }
        this.moveToBackground(this.mForeSticker);
        if (sticker.isShowing()) {
            this.mForeSticker = sticker;
            this.mBackStickers.remove(sticker);
        } else {
            sticker.show();
        }
    }

    private void moveToBackground(IMGSticker sticker) {
        if (sticker == null) {
            return;
        }
        if (!sticker.isShowing()) {
            if (!this.mBackStickers.contains(sticker)) {
                this.mBackStickers.add(sticker);
            }
            if (this.mForeSticker == sticker) {
                this.mForeSticker = null;
            }
        } else {
            sticker.dismiss();
        }
    }

    public void stickAll() {
        this.moveToBackground(this.mForeSticker);
    }

    public void onDismiss(IMGSticker sticker) {
        this.moveToBackground(sticker);
    }

    public void onShowing(IMGSticker sticker) {
        if (this.mForeSticker != sticker) {
            this.moveToForeground(sticker);
        }
    }

    public void onRemoveSticker(IMGSticker sticker) {
        if (this.mForeSticker == sticker) {
            this.mForeSticker = null;
        } else {
            this.mBackStickers.remove(sticker);
        }
    }

    public void onWindowChanged(float width, float height) {
        if (width == 0.0f || height == 0.0f) {
            return;
        }
        this.mWindow.set(0.0f, 0.0f, width, height);
        if (!this.isInitialHoming) {
            this.onInitialHoming(width, height);
        } else {
            this.M.setTranslate(this.mWindow.centerX() - this.mClipFrame.centerX(), this.mWindow.centerY() - this.mClipFrame.centerY());
            this.M.mapRect(this.mFrame);
            this.M.mapRect(this.mClipFrame);
        }
        this.mClipWin.setClipWinSize(width, height);
    }

    private void onInitialHoming(float width, float height) {
        this.mFrame.set(0.0f, 0.0f, (float)this.mImage.getWidth(), (float)this.mImage.getHeight());
        this.mClipFrame.set(this.mFrame);
        this.mClipWin.setClipWinSize(width, height);
        if (this.mClipFrame.isEmpty()) {
            return;
        }
        this.toBaseHoming();
        this.isInitialHoming = true;
        this.onInitialHomingDone();
    }

    private void toBaseHoming() {
        if (this.mClipFrame.isEmpty()) {
            return;
        }
        float scale = Math.min(this.mWindow.width() / this.mClipFrame.width(), this.mWindow.height() / this.mClipFrame.height());
        this.M.setScale(scale, scale, this.mClipFrame.centerX(), this.mClipFrame.centerY());
        this.M.postTranslate(this.mWindow.centerX() - this.mClipFrame.centerX(), this.mWindow.centerY() - this.mClipFrame.centerY());
        this.M.mapRect(this.mFrame);
        this.M.mapRect(this.mClipFrame);
    }

    private void onInitialHomingDone() {
        if (this.mMode == IMGMode.CLIP) {
            this.mClipWin.reset(this.mClipFrame, this.getTargetRotate());
        }
    }

    public void onDrawImage(Canvas canvas) {
        canvas.clipRect(this.mClipWin.isClipping() ? this.mFrame : this.mClipFrame);
        canvas.drawBitmap(this.mImage, null, this.mFrame, null);
    }

    public int onDrawMosaicsPath(Canvas canvas) {
        int layerCount = canvas.saveLayer(this.mFrame, null, 31);
        if (!this.isMosaicEmpty()) {
            canvas.save();
            float scale = this.getScale();
            canvas.translate(this.mFrame.left, this.mFrame.top);
            canvas.scale(scale, scale);
            for (IMGPath path : this.mMosaics) {
                path.onDrawMosaic(canvas, this.mPaint);
            }
            canvas.restore();
        }
        return layerCount;
    }

    public void onDrawMosaic(Canvas canvas, int layerCount) {
        canvas.drawBitmap(this.mMosaicImage, null, this.mFrame, this.mMosaicPaint);
        canvas.restoreToCount(layerCount);
    }

    public void onDrawDoodles(Canvas canvas) {
        if (!this.isDoodleEmpty()) {
            canvas.save();
            float scale = this.getScale();
            canvas.translate(this.mFrame.left, this.mFrame.top);
            canvas.scale(scale, scale);
            for (IMGPath path : this.mDoodles) {
                path.onDrawDoodle(canvas, this.mPaint);
            }
            canvas.restore();
        }
    }

    public void onDrawStickerClip(Canvas canvas) {
        this.M.setRotate(this.getRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
        this.M.mapRect(this.mTempClipFrame, this.mClipWin.isClipping() ? this.mFrame : this.mClipFrame);
        canvas.clipRect(this.mTempClipFrame);
    }

    public void onDrawStickers(Canvas canvas) {
        if (this.mBackStickers.isEmpty()) {
            return;
        }
        canvas.save();
        for (IMGSticker sticker : this.mBackStickers) {
            if (sticker.isShowing()) continue;
            float tPivotX = sticker.getX() + sticker.getPivotX();
            float tPivotY = sticker.getY() + sticker.getPivotY();
            canvas.save();
            this.M.setTranslate(sticker.getX(), sticker.getY());
            this.M.postScale(sticker.getScale(), sticker.getScale(), tPivotX, tPivotY);
            this.M.postRotate(sticker.getRotation(), tPivotX, tPivotY);
            canvas.concat(this.M);
            sticker.onSticker(canvas);
            canvas.restore();
        }
        canvas.restore();
    }

    public void onDrawShade(Canvas canvas) {
        if (this.mMode == IMGMode.CLIP && this.isSteady) {
            this.mShade.reset();
            this.mShade.addRect(this.mFrame.left - 2.0f, this.mFrame.top - 2.0f, this.mFrame.right + 2.0f, this.mFrame.bottom + 2.0f, Path.Direction.CW);
            this.mShade.addRect(this.mClipFrame, Path.Direction.CCW);
            canvas.drawPath(this.mShade, this.mShadePaint);
        }
    }

    public void onDrawClip(Canvas canvas, float scrollX, float scrollY) {
        if (this.mMode == IMGMode.CLIP) {
            this.mClipWin.onDraw(canvas);
        }
    }

    public void onTouchDown(float x, float y) {
        this.isSteady = false;
        this.moveToBackground(this.mForeSticker);
        if (this.mMode == IMGMode.CLIP) {
            this.mAnchor = this.mClipWin.getAnchor(x, y);
        }
    }

    public void onTouchUp(float scrollX, float scrollY) {
        if (this.mAnchor != null) {
            this.mAnchor = null;
        }
    }

    public void onSteady(float scrollX, float scrollY) {
        this.isSteady = true;
        this.onClipHoming();
        this.mClipWin.setShowShade(true);
    }

    public void onScaleBegin() {
    }

    public IMGHoming onScroll(float scrollX, float scrollY, float dx, float dy) {
        if (this.mMode == IMGMode.CLIP) {
            this.mClipWin.setShowShade(false);
            if (this.mAnchor != null) {
                this.mClipWin.onScroll(this.mAnchor, dx, dy);
                RectF clipFrame = new RectF();
                this.M.setRotate(this.getRotate(), this.mClipFrame.centerX(), this.mClipFrame.centerY());
                this.M.mapRect(clipFrame, this.mFrame);
                RectF frame = this.mClipWin.getOffsetFrame(scrollX, scrollY);
                IMGHoming homing = new IMGHoming(scrollX, scrollY, this.getScale(), this.getTargetRotate());
                homing.rConcat(IMGUtils.fillHoming(frame, clipFrame, this.mClipFrame.centerX(), this.mClipFrame.centerY()));
                return homing;
            }
        }
        return null;
    }

    public float getTargetRotate() {
        return this.mTargetRotate;
    }

    public void setTargetRotate(float targetRotate) {
        this.mTargetRotate = targetRotate;
    }

    public void rotate(int rotate) {
        this.mTargetRotate = Math.round((this.mRotate + (float)rotate) / 90.0f) * 90;
        this.mClipWin.reset(this.mClipFrame, this.getTargetRotate());
    }

    public float getRotate() {
        return this.mRotate;
    }

    public void setRotate(float rotate) {
        this.mRotate = rotate;
    }

    public float getScale() {
        return 1.0f * this.mFrame.width() / (float)this.mImage.getWidth();
    }

    public void setScale(float scale) {
        this.setScale(scale, this.mClipFrame.centerX(), this.mClipFrame.centerY());
    }

    public void setScale(float scale, float focusX, float focusY) {
        this.onScale(scale / this.getScale(), focusX, focusY);
    }

    public void onScale(float factor, float focusX, float focusY) {
        if (factor == 1.0f) {
            return;
        }
        if (Math.max(this.mClipFrame.width(), this.mClipFrame.height()) >= 10000.0f || Math.min(this.mClipFrame.width(), this.mClipFrame.height()) <= 500.0f) {
            factor += (1.0f - factor) / 2.0f;
        }
        this.M.setScale(factor, factor, focusX, focusY);
        this.M.mapRect(this.mFrame);
        this.M.mapRect(this.mClipFrame);
        if (!this.mFrame.contains(this.mClipFrame)) {
            // empty if block
        }
        for (IMGSticker sticker : this.mBackStickers) {
            this.M.mapRect(sticker.getFrame());
            float tPivotX = sticker.getX() + sticker.getPivotX();
            float tPivotY = sticker.getY() + sticker.getPivotY();
            sticker.addScale(factor);
            sticker.setX(sticker.getX() + sticker.getFrame().centerX() - tPivotX);
            sticker.setY(sticker.getY() + sticker.getFrame().centerY() - tPivotY);
        }
    }

    public void onScaleEnd() {
    }

    public void onHomingStart(boolean isRotate) {
        this.isAnimCanceled = false;
        this.isDrawClip = true;
    }

    public void onHoming(float fraction) {
        this.mClipWin.homing(fraction);
    }

    public boolean onHomingEnd(float scrollX, float scrollY, boolean isRotate) {
        this.isDrawClip = true;
        if (this.mMode == IMGMode.CLIP) {
            boolean clip = !this.isAnimCanceled;
            this.mClipWin.setHoming(false);
            this.mClipWin.setClipping(true);
            this.mClipWin.setResetting(false);
            return clip;
        }
        if (this.isFreezing && !this.isAnimCanceled) {
            this.setFreezing(false);
        }
        return false;
    }

    public boolean isFreezing() {
        return this.isFreezing;
    }

    private void setFreezing(boolean freezing) {
        if (freezing != this.isFreezing) {
            this.rotateStickers(freezing ? -this.getRotate() : this.getTargetRotate());
            this.isFreezing = freezing;
        }
    }

    public void onHomingCancel(boolean isRotate) {
        this.isAnimCanceled = true;
        Log.d((String)TAG, (String)"Homing cancel");
    }

    public void release() {
        if (this.mImage != null && !this.mImage.isRecycled()) {
            this.mImage.recycle();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (DEFAULT_IMAGE != null) {
            DEFAULT_IMAGE.recycle();
        }
    }
}

