/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.RadioGroup;
import me.kareluo.imaging.R;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.view.IMGColorGroup;

public class IMGTextEditDialog
extends Dialog
implements View.OnClickListener,
RadioGroup.OnCheckedChangeListener {
    private static final String TAG = "IMGTextEditDialog";
    private EditText mEditText;
    private Callback mCallback;
    private IMGText mDefaultText;
    private IMGColorGroup mColorGroup;

    public IMGTextEditDialog(Context context, Callback callback) {
        super(context, R.style.ImageTextDialog);
        this.setContentView(R.layout.image_text_dialog);
        this.mCallback = callback;
        Window window = this.getWindow();
        if (window != null) {
            window.setLayout(-1, -1);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mColorGroup = (IMGColorGroup)this.findViewById(R.id.cg_colors);
        this.mColorGroup.setOnCheckedChangeListener(this);
        this.mEditText = (EditText)this.findViewById(R.id.et_text);
        this.findViewById(R.id.tv_cancel).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.tv_done).setOnClickListener((View.OnClickListener)this);
    }

    protected void onStart() {
        super.onStart();
        if (this.mDefaultText != null) {
            this.mEditText.setText((CharSequence)this.mDefaultText.getText());
            this.mEditText.setTextColor(this.mDefaultText.getColor());
            if (!this.mDefaultText.isEmpty()) {
                this.mEditText.setSelection(this.mEditText.length());
            }
            this.mDefaultText = null;
        } else {
            this.mEditText.setText((CharSequence)"");
        }
        this.mColorGroup.setCheckColor(this.mEditText.getCurrentTextColor());
    }

    public void setText(IMGText text) {
        this.mDefaultText = text;
    }

    public void reset() {
        this.setText(new IMGText(null, -1));
    }

    public void onClick(View v) {
        int vid = v.getId();
        if (vid == R.id.tv_done) {
            this.onDone();
        } else if (vid == R.id.tv_cancel) {
            this.dismiss();
        }
    }

    private void onDone() {
        String text = this.mEditText.getText().toString();
        if (!TextUtils.isEmpty((CharSequence)text) && this.mCallback != null) {
            this.mCallback.onText(new IMGText(text, this.mEditText.getCurrentTextColor()));
        }
        this.dismiss();
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        this.mEditText.setTextColor(this.mColorGroup.getCheckColor());
    }

    public static interface Callback {
        public void onText(IMGText var1);
    }
}

