/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.kareluo.imaging.R;
import me.kareluo.imaging.gallery.IMGGalleryMenuWindow;
import me.kareluo.imaging.gallery.IMGScanTask;
import me.kareluo.imaging.gallery.model.IMGChooseMode;
import me.kareluo.imaging.gallery.model.IMGImageInfo;
import me.kareluo.imaging.gallery.model.IMGImageViewModel;
import me.kareluo.imaging.widget.IMGGalleryHolderCallback;

public class IMGGalleryActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private IMGChooseMode mGalleryMode;
    private TextView mAlbumFolderView;
    private View mFooterView;
    private IMGGalleryMenuWindow mGalleryMenuWindow;
    private Map<String, List<IMGImageViewModel>> mImages;
    private List<IMGImageViewModel> mChooseImages = new ArrayList<IMGImageViewModel>();
    private static final String EXTRA_IMAGES = "IMAGES";
    private static final String EXTRA_CHOOSE_MODE = "CHOOSE_MODE";
    private static final int[] ATTRS = new int[]{R.attr.image_gallery_span_count, R.attr.image_gallery_select_shade};

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.image_gallery_activity);
        this.mGalleryMode = (IMGChooseMode)this.getIntent().getParcelableExtra(EXTRA_CHOOSE_MODE);
        if (this.mGalleryMode == null) {
            this.mGalleryMode = new IMGChooseMode();
        }
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_images);
        this.mAdapter = new ImageAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        new IMGScanTask(this).execute(new Void[0]);
        this.mFooterView = this.findViewById(R.id.layout_footer);
        this.mAlbumFolderView = (TextView)this.findViewById(R.id.tv_album_folder);
        this.mAlbumFolderView.setOnClickListener((View.OnClickListener)this);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.image_menu_gallery, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.image_menu_done) {
            this.onDone();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onImages(Map<String, List<IMGImageViewModel>> images) {
        this.mImages = images;
        if (images != null) {
            this.mAdapter.setModels(images.get("\u6240\u6709\u56fe\u7247"));
            this.mAdapter.notifyDataSetChanged();
            IMGGalleryMenuWindow window = this.getGalleryMenuWindow();
            Set<String> keys = images.keySet();
            ArrayList<String> items = new ArrayList<String>(keys);
            if (!items.isEmpty() && !"\u6240\u6709\u56fe\u7247".equals(items.get(0))) {
                items.remove("\u6240\u6709\u56fe\u7247");
                items.add(0, "\u6240\u6709\u56fe\u7247");
            }
            window.setMenuItems(items);
        }
    }

    public void onQuicklyImages(List<IMGImageViewModel> images) {
        this.mAdapter.setModels(images);
        this.mAdapter.notifyDataSetChanged();
    }

    private void onImageCheckClick(int position) {
        IMGImageViewModel item = this.mAdapter.getItem(position);
        if (item != null) {
            if (!item.isSelected() && this.mChooseImages.size() >= this.mGalleryMode.getMaxChooseCount()) {
                this.mAdapter.notifyItemChanged(position, true);
                return;
            }
            item.toggleSelected();
            if (item.isSelected()) {
                this.mChooseImages.add(item);
            } else {
                this.mChooseImages.remove(item);
            }
            this.mAdapter.notifyItemChanged(position, true);
        }
    }

    private void onImageClick(int position) {
        IMGImageViewModel item = this.mAdapter.getItem(position);
        if (item != null && this.mGalleryMode.isSingleChoose()) {
            this.mChooseImages.clear();
            item.setSelected(true);
            this.mChooseImages.add(item);
            this.onDone();
        }
    }

    private void onDone() {
        ArrayList<IMGImageInfo> infos = new ArrayList<IMGImageInfo>();
        for (IMGImageViewModel model : this.mChooseImages) {
            infos.add(new IMGImageInfo(model));
        }
        this.setResult(-1, new Intent().putParcelableArrayListExtra(EXTRA_IMAGES, infos));
        this.finish();
    }

    private IMGGalleryMenuWindow getGalleryMenuWindow() {
        if (this.mGalleryMenuWindow == null) {
            this.mGalleryMenuWindow = new IMGGalleryMenuWindow((Context)this);
        }
        return this.mGalleryMenuWindow;
    }

    public static ArrayList<IMGImageInfo> getImageInfos(Intent intent) {
        if (intent != null) {
            return intent.getParcelableArrayListExtra(EXTRA_IMAGES);
        }
        return null;
    }

    public static Intent newIntent(Context context, IMGChooseMode mode) {
        return new Intent(context, IMGGalleryActivity.class).putExtra(EXTRA_CHOOSE_MODE, (Parcelable)mode);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_album_folder) {
            this.showGalleryMenu();
        }
    }

    private void showGalleryMenu() {
        IMGGalleryMenuWindow window = this.getGalleryMenuWindow();
        if (window != null) {
            window.show(this.mFooterView);
        }
    }

    private static class ImageViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private CheckBox mCheckBox;
        private SimpleDraweeView mImageView;
        private IMGGalleryHolderCallback mCallback;
        private static Drawable FORE_DRAWABLE = null;

        private ImageViewHolder(View itemView, IMGGalleryHolderCallback callback) {
            super(itemView);
            this.mCallback = callback;
            this.mCheckBox = (CheckBox)itemView.findViewById(R.id.cb_box);
            this.mImageView = (SimpleDraweeView)itemView.findViewById(R.id.sdv_image);
            this.mCheckBox.setOnClickListener((View.OnClickListener)this);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        private void update(IMGImageViewModel model, IMGChooseMode mode) {
            this.mCheckBox.setChecked(model.isSelected());
            this.mCheckBox.setVisibility(mode.isSingleChoose() ? 8 : 0);
            ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)model.getUri()).setLocalThumbnailPreviewsEnabled(true).setResizeOptions(new ResizeOptions(300, 300)).setRotationOptions(RotationOptions.autoRotate()).build();
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setOldController(this.mImageView.getController())).setImageRequest((Object)request)).build();
            this.mImageView.setController((DraweeController)controller);
        }

        public void onClick(View v) {
            if (this.mCallback != null) {
                if (v.getId() == R.id.cb_box) {
                    this.mCallback.onCheckClick(this);
                } else {
                    this.mCallback.onViewHolderClick(this);
                }
            }
        }
    }

    private class ImageAdapter
    extends RecyclerView.Adapter<ImageViewHolder>
    implements IMGGalleryHolderCallback {
        private List<IMGImageViewModel> models;

        private ImageAdapter() {
        }

        private void setModels(List<IMGImageViewModel> models) {
            this.models = models;
        }

        public ImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ImageViewHolder(IMGGalleryActivity.this.getLayoutInflater().inflate(R.layout.image_layout_image, parent, false), this);
        }

        public void onBindViewHolder(ImageViewHolder holder, int position) {
            holder.update(this.models.get(position), IMGGalleryActivity.this.mGalleryMode);
        }

        public int getItemCount() {
            return this.models != null ? this.models.size() : 0;
        }

        private IMGImageViewModel getItem(int position) {
            if (position >= 0 && position < this.getItemCount()) {
                return this.models.get(position);
            }
            return null;
        }

        @Override
        public void onViewHolderClick(RecyclerView.ViewHolder holder) {
            IMGGalleryActivity.this.onImageClick(holder.getAdapterPosition());
        }

        @Override
        public void onCheckClick(RecyclerView.ViewHolder holder) {
            IMGGalleryActivity.this.onImageCheckClick(holder.getAdapterPosition());
        }
    }
}

