/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.View;
import android.widget.RadioGroup;
import android.widget.ViewSwitcher;
import me.kareluo.imaging.IMGTextEditDialog;
import me.kareluo.imaging.R;
import me.kareluo.imaging.core.IMGMode;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.view.IMGColorGroup;
import me.kareluo.imaging.view.IMGView;

abstract class IMGEditBaseActivity
extends Activity
implements View.OnClickListener,
IMGTextEditDialog.Callback,
RadioGroup.OnCheckedChangeListener,
DialogInterface.OnShowListener,
DialogInterface.OnDismissListener {
    protected IMGView mImgView;
    private RadioGroup mModeGroup;
    private IMGColorGroup mColorGroup;
    private IMGTextEditDialog mTextDialog;
    private View mLayoutOpSub;
    private ViewSwitcher mOpSwitcher;
    private ViewSwitcher mOpSubSwitcher;
    public static final int OP_HIDE = -1;
    public static final int OP_NORMAL = 0;
    public static final int OP_CLIP = 1;
    public static final int OP_SUB_DOODLE = 0;
    public static final int OP_SUB_MOSAIC = 1;

    IMGEditBaseActivity() {
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bitmap bitmap = this.getBitmap();
        if (bitmap != null) {
            this.setContentView(R.layout.image_edit_activity);
            this.initViews();
            this.mImgView.setImageBitmap(bitmap);
            this.onCreated();
        } else {
            this.finish();
        }
    }

    public void onCreated() {
    }

    private void initViews() {
        this.mImgView = (IMGView)this.findViewById(R.id.image_canvas);
        this.mModeGroup = (RadioGroup)this.findViewById(R.id.rg_modes);
        this.mOpSwitcher = (ViewSwitcher)this.findViewById(R.id.vs_op);
        this.mOpSubSwitcher = (ViewSwitcher)this.findViewById(R.id.vs_op_sub);
        this.mColorGroup = (IMGColorGroup)this.findViewById(R.id.cg_colors);
        this.mColorGroup.setOnCheckedChangeListener(this);
        this.mLayoutOpSub = this.findViewById(R.id.layout_op_sub);
    }

    public void onClick(View v) {
        int vid = v.getId();
        if (vid == R.id.rb_doodle) {
            this.onModeClick(IMGMode.DOODLE);
        } else if (vid == R.id.btn_text) {
            this.onTextModeClick();
        } else if (vid == R.id.rb_mosaic) {
            this.onModeClick(IMGMode.MOSAIC);
        } else if (vid == R.id.btn_clip) {
            this.onModeClick(IMGMode.CLIP);
        } else if (vid == R.id.btn_undo) {
            this.onUndoClick();
        } else if (vid == R.id.tv_done) {
            this.onDoneClick();
        } else if (vid == R.id.tv_cancel) {
            this.onCancelClick();
        } else if (vid == R.id.ib_clip_cancel) {
            this.onCancelClipClick();
        } else if (vid == R.id.ib_clip_done) {
            this.onDoneClipClick();
        } else if (vid == R.id.tv_clip_reset) {
            this.onResetClipClick();
        } else if (vid == R.id.ib_clip_rotate) {
            this.onRotateClipClick();
        }
    }

    public void updateModeUI() {
        IMGMode mode = this.mImgView.getMode();
        switch (mode) {
            case DOODLE: {
                this.mModeGroup.check(R.id.rb_doodle);
                this.setOpSubDisplay(0);
                break;
            }
            case MOSAIC: {
                this.mModeGroup.check(R.id.rb_mosaic);
                this.setOpSubDisplay(1);
                break;
            }
            case NONE: {
                this.mModeGroup.clearCheck();
                this.setOpSubDisplay(-1);
            }
        }
    }

    public void onTextModeClick() {
        if (this.mTextDialog == null) {
            this.mTextDialog = new IMGTextEditDialog((Context)this, this);
            this.mTextDialog.setOnShowListener(this);
            this.mTextDialog.setOnDismissListener(this);
        }
        this.mTextDialog.show();
    }

    public final void onCheckedChanged(RadioGroup group, int checkedId) {
        this.onColorChanged(this.mColorGroup.getCheckColor());
    }

    public void setOpDisplay(int op) {
        if (op >= 0) {
            this.mOpSwitcher.setDisplayedChild(op);
        }
    }

    public void setOpSubDisplay(int opSub) {
        if (opSub < 0) {
            this.mLayoutOpSub.setVisibility(8);
        } else {
            this.mOpSubSwitcher.setDisplayedChild(opSub);
            this.mLayoutOpSub.setVisibility(0);
        }
    }

    public void onShow(DialogInterface dialog) {
        this.mOpSwitcher.setVisibility(8);
    }

    public void onDismiss(DialogInterface dialog) {
        this.mOpSwitcher.setVisibility(0);
    }

    public abstract Bitmap getBitmap();

    public abstract void onModeClick(IMGMode var1);

    public abstract void onUndoClick();

    public abstract void onCancelClick();

    public abstract void onDoneClick();

    public abstract void onCancelClipClick();

    public abstract void onDoneClipClick();

    public abstract void onResetClipClick();

    public abstract void onRotateClipClick();

    public abstract void onColorChanged(int var1);

    @Override
    public abstract void onText(IMGText var1);
}

