/*
 * Decompiled with CFR 0.152.
 */
package me.kareluo.imaging;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import me.kareluo.imaging.IMGEditBaseActivity;
import me.kareluo.imaging.core.IMGMode;
import me.kareluo.imaging.core.IMGText;
import me.kareluo.imaging.core.file.IMGAssetFileDecoder;
import me.kareluo.imaging.core.file.IMGDecoder;
import me.kareluo.imaging.core.file.IMGFileDecoder;
import me.kareluo.imaging.core.util.IMGUtils;

public class IMGEditActivity
extends IMGEditBaseActivity {
    private static final int MAX_WIDTH = 1024;
    private static final int MAX_HEIGHT = 1024;
    public static final String EXTRA_IMAGE_URI = "IMAGE_URI";
    public static final String EXTRA_IMAGE_SAVE_PATH = "IMAGE_SAVE_PATH";

    public static void startForResult(Activity ctx, Uri imageUri, String savePath, int requestCode) {
        Intent intent = new Intent((Context)ctx, IMGEditActivity.class);
        intent.putExtra(EXTRA_IMAGE_URI, (Parcelable)imageUri);
        intent.putExtra(EXTRA_IMAGE_SAVE_PATH, savePath);
        ctx.startActivityForResult(intent, requestCode);
    }

    @Override
    public void onCreated() {
    }

    @Override
    public Bitmap getBitmap() {
        Intent intent = this.getIntent();
        if (intent == null) {
            return null;
        }
        Uri uri = (Uri)intent.getParcelableExtra(EXTRA_IMAGE_URI);
        if (uri == null) {
            return null;
        }
        IMGDecoder decoder = null;
        String path = uri.getPath();
        if (!TextUtils.isEmpty((CharSequence)path)) {
            switch (uri.getScheme()) {
                case "asset": {
                    decoder = new IMGAssetFileDecoder((Context)this, uri);
                    break;
                }
                case "file": {
                    decoder = new IMGFileDecoder(uri);
                }
            }
        }
        if (decoder == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 1;
        options.inJustDecodeBounds = true;
        decoder.decode(options);
        if (options.outWidth > 1024) {
            options.inSampleSize = IMGUtils.inSampleSize(Math.round(1.0f * (float)options.outWidth / 1024.0f));
        }
        if (options.outHeight > 1024) {
            options.inSampleSize = Math.max(options.inSampleSize, IMGUtils.inSampleSize(Math.round(1.0f * (float)options.outHeight / 1024.0f)));
        }
        options.inJustDecodeBounds = false;
        Bitmap bitmap = decoder.decode(options);
        if (bitmap == null) {
            return null;
        }
        return bitmap;
    }

    @Override
    public void onText(IMGText text) {
        this.mImgView.addStickerText(text);
    }

    @Override
    public void onModeClick(IMGMode mode) {
        IMGMode cm = this.mImgView.getMode();
        if (cm == mode) {
            mode = IMGMode.NONE;
        }
        this.mImgView.setMode(mode);
        this.updateModeUI();
        if (mode == IMGMode.CLIP) {
            this.setOpDisplay(1);
        }
    }

    @Override
    public void onUndoClick() {
        IMGMode mode = this.mImgView.getMode();
        if (mode == IMGMode.DOODLE) {
            this.mImgView.undoDoodle();
        } else if (mode == IMGMode.MOSAIC) {
            this.mImgView.undoMosaic();
        }
    }

    @Override
    public void onCancelClick() {
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDoneClick() {
        Bitmap bitmap;
        String path = this.getIntent().getStringExtra(EXTRA_IMAGE_SAVE_PATH);
        if (!TextUtils.isEmpty((CharSequence)path) && (bitmap = this.mImgView.saveBitmap()) != null) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fout);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.setResult(-1);
            this.finish();
            return;
        }
        this.setResult(0);
        this.finish();
    }

    @Override
    public void onCancelClipClick() {
        this.mImgView.cancelClip();
        this.setOpDisplay(this.mImgView.getMode() == IMGMode.CLIP ? 1 : 0);
    }

    @Override
    public void onDoneClipClick() {
        this.mImgView.doClip();
        this.setOpDisplay(this.mImgView.getMode() == IMGMode.CLIP ? 1 : 0);
    }

    @Override
    public void onResetClipClick() {
        this.mImgView.resetClip();
    }

    @Override
    public void onRotateClipClick() {
        this.mImgView.doRotate();
    }

    @Override
    public void onColorChanged(int checkedColor) {
        this.mImgView.setPenColor(checkedColor);
    }
}

