/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me.model;

import android.text.TextUtils;
import com.github.jberkel.pay.me.model.ItemType;
import org.json.JSONException;
import org.json.JSONObject;

public class Purchase {
    private final String mOrderId;
    private final String mPackageName;
    private final String mSku;
    private final long mPurchaseTime;
    private final int mPurchaseState;
    private final String mDeveloperPayload;
    private final String mToken;
    private final ItemType mItemType;
    private final State mState;
    private final String mSignature;
    private final String mOriginalJson;
    private static final String PACKAGE_NAME = "packageName";
    private static final String PRODUCT_ID = "productId";
    private static final String PURCHASE_TIME = "purchaseTime";
    private static final String PURCHASE_STATE = "purchaseState";
    private static final String DEVELOPER_PAYLOAD = "developerPayload";
    private static final String PURCHASE_TOKEN = "purchaseToken";
    private static final String TOKEN = "token";
    private static final String ORDER_ID = "orderId";

    public Purchase(ItemType itemType, String jsonPurchaseInfo, String signature) throws JSONException {
        if (itemType == null) {
            throw new IllegalArgumentException("itemType cannot be null");
        }
        this.mItemType = itemType;
        JSONObject json = new JSONObject(jsonPurchaseInfo);
        this.mOrderId = json.optString(ORDER_ID);
        this.mPackageName = json.optString(PACKAGE_NAME);
        this.mSku = json.optString(PRODUCT_ID);
        this.mPurchaseTime = json.optLong(PURCHASE_TIME);
        this.mPurchaseState = json.optInt(PURCHASE_STATE);
        this.mDeveloperPayload = json.optString(DEVELOPER_PAYLOAD);
        this.mToken = json.optString(TOKEN, json.optString(PURCHASE_TOKEN));
        this.mOriginalJson = jsonPurchaseInfo;
        this.mSignature = signature;
        this.mState = State.fromCode(this.mPurchaseState);
        if (TextUtils.isEmpty((CharSequence)this.mSku)) {
            throw new JSONException("SKU is empty");
        }
    }

    public ItemType getItemType() {
        return this.mItemType;
    }

    public String getOrderId() {
        return this.mOrderId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getSku() {
        return this.mSku;
    }

    public long getPurchaseTime() {
        return this.mPurchaseTime;
    }

    public int getRawState() {
        return this.mPurchaseState;
    }

    public State getState() {
        return this.mState;
    }

    public String getDeveloperPayload() {
        return this.mDeveloperPayload;
    }

    public String getToken() {
        return this.mToken;
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return "Purchase(type:" + (Object)((Object)this.mItemType) + "):" + this.mOriginalJson;
    }

    public static enum State {
        PURCHASED(0),
        CANCELED(1),
        REFUNDED(2),
        UNKNOWN(-1);

        final int code;

        private State(int code) {
            this.code = code;
        }

        public static State fromCode(int code) {
            for (State s : State.values()) {
                if (s.code != code) continue;
                return s;
            }
            return UNKNOWN;
        }
    }
}

