/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me;

import android.os.AsyncTask;
import com.github.jberkel.pay.me.IabException;
import com.github.jberkel.pay.me.IabHelper;
import com.github.jberkel.pay.me.IabResult;
import com.github.jberkel.pay.me.Response;
import com.github.jberkel.pay.me.listener.QueryInventoryFinishedListener;
import com.github.jberkel.pay.me.model.Inventory;
import java.util.List;

class QueryInventoryTask
extends AsyncTask<Args, Void, Inventory> {
    private final IabHelper mIabHelper;
    private final QueryInventoryFinishedListener mListener;
    private IabResult mResult = new IabResult(Response.OK);

    public QueryInventoryTask(IabHelper iabHelper, QueryInventoryFinishedListener listener) {
        this.mIabHelper = iabHelper;
        this.mListener = listener;
    }

    protected void onPreExecute() {
        this.mIabHelper.flagStartAsync("refresh inventory");
    }

    protected Inventory doInBackground(Args ... args) {
        if (args == null || args.length == 0 || args[0] == null) {
            throw new IllegalArgumentException("need args");
        }
        Args arg = args[0];
        try {
            return this.mIabHelper.queryInventory(arg.queryDetails, arg.skus, arg.subSkus);
        }
        catch (IabException ex) {
            this.mResult = ex.getResult();
            return null;
        }
    }

    protected void onPostExecute(Inventory inventory) {
        this.mIabHelper.flagEndAsync();
        if (this.mListener != null && !this.mIabHelper.isDisposed() && !this.isCancelled()) {
            this.mListener.onQueryInventoryFinished(this.mResult, inventory);
        }
    }

    static class Args {
        final boolean queryDetails;
        final List<String> skus;
        final List<String> subSkus;

        public Args(boolean querySkuDetails, List<String> moreSkus, List<String> moreSubSkus) {
            this.queryDetails = querySkuDetails;
            this.skus = moreSkus;
            this.subSkus = moreSubSkus;
        }
    }
}

