/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me;

import android.content.res.Resources;
import com.github.jberkel.pay.me.Response;

public class IabResult {
    private final Response mResponse;
    private final String mMessage;

    public IabResult(int code, String message) {
        this(Response.fromCode(code), message);
    }

    public IabResult(Response response) {
        this(response, null);
    }

    public IabResult(Response response, String message) {
        this.mResponse = response;
        this.mMessage = message == null || message.trim().length() == 0 ? response.description : message + " (response: " + response.description + ")";
    }

    public Response getResponse() {
        return this.mResponse;
    }

    public String getLocalizedMessage(Resources resources) {
        return resources.getString(this.mResponse.stringId);
    }

    public String getMessage() {
        return this.mMessage;
    }

    public boolean isSuccess() {
        return this.mResponse == Response.OK;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public String toString() {
        return "IabResult: " + this.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IabResult iabResult = (IabResult)o;
        return this.mResponse == iabResult.mResponse;
    }

    public int hashCode() {
        return this.mResponse.hashCode();
    }
}

