/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.android.vending.billing.IInAppBillingService;
import com.github.jberkel.pay.me.ConsumeTask;
import com.github.jberkel.pay.me.IabException;
import com.github.jberkel.pay.me.IabResult;
import com.github.jberkel.pay.me.PurchaseFlowState;
import com.github.jberkel.pay.me.QueryInventoryTask;
import com.github.jberkel.pay.me.Response;
import com.github.jberkel.pay.me.listener.OnConsumeFinishedListener;
import com.github.jberkel.pay.me.listener.OnConsumeMultiFinishedListener;
import com.github.jberkel.pay.me.listener.OnIabPurchaseFinishedListener;
import com.github.jberkel.pay.me.listener.OnIabSetupFinishedListener;
import com.github.jberkel.pay.me.listener.QueryInventoryFinishedListener;
import com.github.jberkel.pay.me.model.Inventory;
import com.github.jberkel.pay.me.model.ItemType;
import com.github.jberkel.pay.me.model.Purchase;
import com.github.jberkel.pay.me.model.SkuDetails;
import com.github.jberkel.pay.me.validator.DefaultSignatureValidator;
import com.github.jberkel.pay.me.validator.SignatureValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public class IabHelper {
    static final Intent BIND_BILLING_SERVICE = new Intent("com.android.vending.billing.InAppBillingService.BIND").setPackage("com.android.vending");
    private Context mContext;
    private IInAppBillingService mService;
    private BillingServiceConnection mServiceConn;
    private PurchaseFlowState mPurchaseFlowState = PurchaseFlowState.NONE;
    private SignatureValidator mSignatureValidator;
    private boolean mSetupDone;
    private boolean mDisposed;
    private boolean mSubscriptionsSupported;
    private boolean mInAppSupported;
    private boolean mDebugLog;
    private String mDebugTag = "IabHelper";
    private boolean mAsyncInProgress;
    private String mAsyncOperation = "";

    public IabHelper(Context ctx, String base64PublicKey) {
        this(ctx, new DefaultSignatureValidator(base64PublicKey));
    }

    public IabHelper(Context ctx, SignatureValidator validator) {
        if (ctx == null) {
            throw new IllegalArgumentException("need non-null context");
        }
        if (validator == null) {
            throw new IllegalArgumentException("need non-null validator");
        }
        this.mContext = ctx.getApplicationContext();
        this.mSignatureValidator = validator;
        this.logDebug("IAB helper created.");
    }

    public void startSetup(OnIabSetupFinishedListener listener) {
        this.checkNotDisposedAndThrow();
        if (this.mSetupDone) {
            throw new IllegalStateException("IAB helper is already set up.");
        }
        this.logDebug("Starting in-app billing setup.");
        if (!this.mContext.getPackageManager().queryIntentServices(BIND_BILLING_SERVICE, 0).isEmpty()) {
            this.mServiceConn = new BillingServiceConnection(listener);
            if (!this.mContext.bindService(BIND_BILLING_SERVICE, (ServiceConnection)this.mServiceConn, 1)) {
                this.logWarn("Could not bind to service");
            }
        } else {
            this.mSetupDone = true;
            if (listener != null) {
                listener.onIabSetupFinished(new IabResult(Response.BILLING_UNAVAILABLE));
            }
        }
    }

    public void dispose() {
        this.logDebug("Disposing.");
        this.mSetupDone = false;
        if (this.mServiceConn != null) {
            this.logDebug("Unbinding from service.");
            if (this.mContext != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConn);
            }
        }
        this.mDisposed = true;
        this.mContext = null;
        this.mServiceConn = null;
        this.mService = null;
        this.mPurchaseFlowState = PurchaseFlowState.NONE;
    }

    public void launchPurchaseFlow(Activity activity, String sku, ItemType itemType, int requestCode, OnIabPurchaseFinishedListener listener, String developerPayload) {
        block13: {
            if (TextUtils.isEmpty((CharSequence)sku)) {
                throw new IllegalArgumentException("Empty sku");
            }
            if (itemType == null) {
                throw new IllegalArgumentException("Empty itemType");
            }
            if (this.isDisposed()) {
                if (listener != null) {
                    listener.onIabPurchaseFinished(new IabResult(Response.IABHELPER_DISPOSED), null);
                }
                return;
            }
            this.checkSetupDone("launchPurchaseFlow");
            this.flagStartAsync("launchPurchaseFlow");
            if (itemType == ItemType.SUBS && !this.mSubscriptionsSupported || itemType == ItemType.INAPP && !this.mInAppSupported) {
                this.flagEndAsync();
                if (listener != null) {
                    listener.onIabPurchaseFinished(new IabResult(itemType == ItemType.INAPP ? Response.BILLING_UNAVAILABLE : Response.IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE), null);
                }
                return;
            }
            try {
                this.logDebug("Constructing buy intent for " + sku + ", item type: " + (Object)((Object)itemType));
                Bundle buyIntentBundle = this.mService.getBuyIntent(3, this.mContext.getPackageName(), sku, itemType.toString(), developerPayload);
                int response = this.getResponseCodeFromBundle(buyIntentBundle);
                if (response != Response.OK.code) {
                    this.logError("Unable to buy item, Error response: " + Response.getDescription(response));
                    this.flagEndAsync();
                    if (listener != null) {
                        listener.onIabPurchaseFinished(new IabResult(response, "Unable to buy item"), null);
                    }
                    return;
                }
                PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable("BUY_INTENT");
                if (pendingIntent == null) {
                    throw new IntentSender.SendIntentException("No pending intent");
                }
                this.logDebug("Launching buy intent for " + sku + ". Request code: " + requestCode);
                this.mPurchaseFlowState = new PurchaseFlowState(requestCode, itemType, listener);
                activity.startIntentSenderForResult(pendingIntent.getIntentSender(), requestCode, new Intent(), 0, 0, 0);
            }
            catch (IntentSender.SendIntentException e) {
                this.logError("SendIntentException while launching purchase flow for sku " + sku, e);
                this.flagEndAsync();
                if (listener != null) {
                    listener.onIabPurchaseFinished(new IabResult(Response.IABHELPER_SEND_INTENT_FAILED), null);
                }
            }
            catch (RemoteException e) {
                this.logError("RemoteException while launching purchase flow for sku " + sku, e);
                this.flagEndAsync();
                if (listener == null) break block13;
                listener.onIabPurchaseFinished(new IabResult(Response.IABHELPER_REMOTE_EXCEPTION), null);
            }
        }
    }

    public boolean handleActivityResult(int requestCode, int intentResultCode, Intent intent) {
        if (this.mPurchaseFlowState == PurchaseFlowState.NONE) {
            return false;
        }
        if (requestCode != this.mPurchaseFlowState.requestCode) {
            return false;
        }
        this.checkSetupDone("handleActivityResult");
        this.flagEndAsync();
        if (intent == null) {
            this.logError("Null data in IAB activity result.");
            this.mPurchaseFlowState.onIabPurchaseFinished(new IabResult(Response.IABHELPER_BAD_RESPONSE, "Null data in IAB result"), null);
            return true;
        }
        int responseCode = this.getResponseCodeFromBundle(intent.getExtras());
        this.logDebug("handleActivityResult: resultCode=" + intentResultCode + ", response code=" + responseCode);
        if (intentResultCode == -1) {
            if (responseCode == Response.OK.code) {
                this.handlePurchaseResult(intent.getStringExtra("INAPP_PURCHASE_DATA"), intent.getStringExtra("INAPP_DATA_SIGNATURE"), this.mPurchaseFlowState);
            } else {
                this.logDebug("Result code was OK but in-app billing response was not OK: " + Response.getDescription(responseCode));
                this.mPurchaseFlowState.onIabPurchaseFinished(new IabResult(responseCode, "Problem purchasing item."), null);
            }
            return true;
        }
        if (intentResultCode == 0) {
            this.logDebug("Purchase canceled - Response: " + Response.getDescription(responseCode));
            this.mPurchaseFlowState.onIabPurchaseFinished(new IabResult(responseCode, null), null);
            return true;
        }
        this.logError("Purchase failed. Result code: " + Integer.toString(intentResultCode) + ". Response: " + Response.getDescription(responseCode));
        this.mPurchaseFlowState.onIabPurchaseFinished(new IabResult(Response.IABHELPER_UNKNOWN_PURCHASE_RESPONSE), null);
        return false;
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreItemSkus, List<String> moreSubsSkus) throws IabException {
        this.checkNotDisposed();
        this.checkSetupDone("queryInventory");
        try {
            Inventory inventory = new Inventory();
            this.queryPurchasesAndDetails(ItemType.INAPP, inventory, querySkuDetails, moreItemSkus);
            if (this.subscriptionsSupported()) {
                this.queryPurchasesAndDetails(ItemType.SUBS, inventory, querySkuDetails, moreSubsSkus);
            }
            return inventory;
        }
        catch (RemoteException e) {
            throw new IabException(Response.IABHELPER_REMOTE_EXCEPTION, "Remote exception while refreshing inventory.", (Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new IabException(Response.IABHELPER_BAD_RESPONSE, "Error parsing JSON response while refreshing inventory.", (Exception)((Object)e));
        }
    }

    public void queryInventoryAsync(boolean querySkuDetails, List<String> moreSkus, List<String> moreSubSkus, QueryInventoryFinishedListener listener) {
        if (this.isDisposed()) {
            if (listener != null) {
                listener.onQueryInventoryFinished(new IabResult(Response.IABHELPER_DISPOSED), null);
            }
            return;
        }
        this.checkSetupDone("queryInventory");
        new QueryInventoryTask(this, listener).execute(new QueryInventoryTask.Args[]{new QueryInventoryTask.Args(querySkuDetails, moreSkus, moreSubSkus)});
    }

    public void queryInventoryAsync(QueryInventoryFinishedListener listener) {
        this.queryInventoryAsync(true, null, null, listener);
    }

    public void consume(Purchase purchase) throws IabException {
        this.checkNotDisposed();
        this.checkSetupDone("consume");
        if (purchase.getItemType() != ItemType.INAPP) {
            throw new IabException(Response.IABHELPER_INVALID_CONSUMPTION, "Items of type '" + (Object)((Object)purchase.getItemType()) + "' can't be consumed.");
        }
        try {
            String token = purchase.getToken();
            String sku = purchase.getSku();
            if (token == null || token.equals("")) {
                this.logError("Can't consume " + sku + ". No token.");
                throw new IabException(Response.IABHELPER_MISSING_TOKEN, "PurchaseInfo is missing token for sku: " + sku + " " + purchase);
            }
            this.logDebug("Consuming sku: " + sku + ", token: " + token);
            int response = this.mService.consumePurchase(3, this.mContext.getPackageName(), token);
            if (response != Response.OK.code) {
                this.logDebug("Error consuming consuming sku " + sku + ". " + Response.getDescription(response));
                throw new IabException(response, "Error consuming sku " + sku);
            }
            this.logDebug("Successfully consumed sku: " + sku);
        }
        catch (RemoteException e) {
            throw new IabException(Response.IABHELPER_REMOTE_EXCEPTION, "Remote exception while consuming. PurchaseInfo: " + purchase, (Exception)((Object)e));
        }
    }

    public void consumeAsync(Purchase purchase, OnConsumeFinishedListener listener) {
        if (this.isDisposed()) {
            if (listener != null) {
                listener.onConsumeFinished(null, new IabResult(Response.IABHELPER_DISPOSED));
            }
            return;
        }
        this.checkSetupDone("consume");
        this.consumeAsyncInternal(Arrays.asList(purchase), listener, null);
    }

    public void consumeAsync(List<Purchase> purchases, OnConsumeMultiFinishedListener listener) {
        if (this.isDisposed()) {
            if (listener != null) {
                listener.onConsumeMultiFinished(new ArrayList<Purchase>(), new ArrayList<IabResult>());
            }
            return;
        }
        this.checkSetupDone("consume");
        this.consumeAsyncInternal(purchases, null, listener);
    }

    public boolean subscriptionsSupported() {
        return !this.isDisposed() && this.mSubscriptionsSupported;
    }

    public void enableDebugLogging(boolean enable, String tag) {
        this.checkNotDisposedAndThrow();
        this.enableDebugLogging(enable);
        this.mDebugTag = tag;
    }

    public void enableDebugLogging(boolean enable) {
        this.checkNotDisposedAndThrow();
        this.mDebugLog = enable;
    }

    void checkSetupDone(String operation) {
        if (!this.mSetupDone) {
            this.logError("Illegal state for operation (" + operation + "): IAB helper is not set up.");
            throw new IllegalStateException("IAB helper is not set up. Can't perform operation: " + operation);
        }
    }

    int getResponseCodeFromBundle(Bundle bundle) {
        Object o;
        if (bundle == null || (o = bundle.get("RESPONSE_CODE")) == null) {
            this.logDebug("Bundle with null response code, assuming OK (known issue)");
            return Response.OK.code;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        this.logError("Unexpected type for bundle response code.");
        this.logError(o.getClass().getName());
        throw new RuntimeException("Unexpected type for bundle response code: " + o.getClass().getName());
    }

    void flagStartAsync(String operation) {
        if (this.mAsyncInProgress) {
            throw new IllegalStateException("Can't start async operation (" + operation + ") because another async operation(" + this.mAsyncOperation + ") is in progress.");
        }
        this.mAsyncOperation = operation;
        this.mAsyncInProgress = true;
        this.logDebug("Starting async operation: " + operation);
    }

    void flagEndAsync() {
        this.logDebug("Ending async operation: " + this.mAsyncOperation);
        this.mAsyncOperation = "";
        this.mAsyncInProgress = false;
    }

    boolean isDisposed() {
        return this.mDisposed;
    }

    private void checkNotDisposed() throws IabException {
        if (this.isDisposed()) {
            throw new IabException(Response.IABHELPER_DISPOSED, null);
        }
    }

    private void checkNotDisposedAndThrow() throws IllegalStateException {
        if (this.isDisposed()) {
            throw new IllegalStateException("IabHelper was disposed of, so it cannot be used.");
        }
    }

    private void handlePurchaseResult(String purchaseData, String dataSignature, PurchaseFlowState purchaseState) {
        if (purchaseData == null || dataSignature == null) {
            this.logError("BUG: either purchaseData or dataSignature is null. data=" + purchaseData + ", signature=" + dataSignature);
            purchaseState.onIabPurchaseFinished(new IabResult(Response.IABHELPER_UNKNOWN_ERROR, "IAB returned null purchaseData or dataSignature"), null);
            return;
        }
        try {
            Purchase purchase = new Purchase(purchaseState.itemType, purchaseData, dataSignature);
            if (!this.mSignatureValidator.validate(purchaseData, dataSignature)) {
                this.logError("Purchase signature verification FAILED for " + purchase);
                purchaseState.onIabPurchaseFinished(new IabResult(Response.IABHELPER_VERIFICATION_FAILED, "Signature verification failed for purchase " + purchase), purchase);
                return;
            }
            this.logDebug("Purchase signature successfully verified.");
            purchaseState.onIabPurchaseFinished(new IabResult(Response.OK), purchase);
        }
        catch (JSONException e) {
            this.logError("Failed to parse purchase data.", e);
            purchaseState.onIabPurchaseFinished(new IabResult(Response.IABHELPER_BAD_RESPONSE, "Failed to parse purchase data."), null);
        }
    }

    private void queryPurchasesAndDetails(ItemType itemType, Inventory inventory, boolean queryDetails, List<String> extraSkus) throws JSONException, RemoteException, IabException {
        this.checkNotDisposed();
        int result = this.queryPurchases(inventory, itemType);
        if (result != Response.OK.code) {
            throw new IabException(result, "Error querying purchases for " + (Object)((Object)itemType));
        }
        if (queryDetails && (result = this.querySkuDetails(itemType, inventory, extraSkus)) != Response.OK.code) {
            throw new IabException(result, "Error querying purchase details for " + (Object)((Object)itemType));
        }
    }

    private int queryPurchases(Inventory inv, ItemType itemType) throws JSONException, RemoteException, IabException {
        this.checkNotDisposed();
        this.logDebug("Querying owned items, item type: " + (Object)((Object)itemType));
        boolean verificationFailed = false;
        String continueToken = null;
        do {
            Bundle ownedItems;
            int response;
            if ((response = this.getResponseCodeFromBundle(ownedItems = this.mService.getPurchases(3, this.mContext.getPackageName(), itemType.toString(), continueToken))) != Response.OK.code) {
                this.logDebug("getPurchases() failed: " + Response.getDescription(response));
                return response;
            }
            if (!(ownedItems != null && ownedItems.containsKey("INAPP_PURCHASE_ITEM_LIST") && ownedItems.containsKey("INAPP_PURCHASE_DATA_LIST") && ownedItems.containsKey("INAPP_DATA_SIGNATURE_LIST"))) {
                this.logError("Bundle returned from getPurchases() doesn't contain required fields.");
                return Response.IABHELPER_BAD_RESPONSE.code;
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList purchaseDataList = ownedItems.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList signatureList = ownedItems.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            if (signatureList.size() < purchaseDataList.size() || ownedSkus.size() < purchaseDataList.size()) {
                this.logError("invalid data returned by service");
                return Response.ERROR.code;
            }
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                String signature;
                String purchaseData = (String)purchaseDataList.get(i);
                if (this.mSignatureValidator.validate(purchaseData, signature = (String)signatureList.get(i))) {
                    Purchase purchase = new Purchase(itemType, purchaseData, signature);
                    if (TextUtils.isEmpty((CharSequence)purchase.getToken())) {
                        this.logWarn("BUG: empty/null token!");
                        this.logDebug("Purchase data: " + purchaseData);
                    }
                    inv.addPurchase(purchase);
                    continue;
                }
                this.logWarn("Purchase signature verification **FAILED**. Not adding item.");
                this.logDebug("   Purchase data: " + purchaseData);
                this.logDebug("   Signature: " + signature);
                verificationFailed = true;
            }
            continueToken = ownedItems.getString("INAPP_CONTINUATION_TOKEN");
            this.logDebug("Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return verificationFailed ? Response.IABHELPER_VERIFICATION_FAILED.code : Response.OK.code;
    }

    private int querySkuDetails(ItemType itemType, Inventory inv, List<String> moreSkus) throws RemoteException, JSONException {
        this.logDebug("Querying SKU details.");
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.addAll(inv.getAllOwnedSkus(itemType));
        if (moreSkus != null) {
            for (String sku : moreSkus) {
                if (skuList.contains(sku)) continue;
                skuList.add(sku);
            }
        }
        if (skuList.isEmpty()) {
            this.logDebug("querySkuDetails: nothing to do because there are no SKUs.");
            return Response.OK.code;
        }
        Bundle querySkus = new Bundle();
        querySkus.putStringArrayList("ITEM_ID_LIST", skuList);
        Bundle skuDetails = this.mService.getSkuDetails(3, this.mContext.getPackageName(), itemType.toString(), querySkus);
        if (skuDetails == null) {
            return Response.IABHELPER_BAD_RESPONSE.code;
        }
        if (!skuDetails.containsKey("DETAILS_LIST")) {
            int response = this.getResponseCodeFromBundle(skuDetails);
            if (response != Response.OK.code) {
                this.logWarn("getSkuDetails() failed: " + Response.getDescription(response));
                return response;
            }
            this.logError("getSkuDetails() returned a bundle with neither an error nor a detail list.");
            return Response.IABHELPER_BAD_RESPONSE.code;
        }
        ArrayList responseList = skuDetails.getStringArrayList("DETAILS_LIST");
        for (String json : responseList) {
            inv.addSkuDetails(new SkuDetails(json));
        }
        return Response.OK.code;
    }

    private ConsumeTask consumeAsyncInternal(List<Purchase> purchases, OnConsumeFinishedListener singleListener, OnConsumeMultiFinishedListener multiListener) {
        return (ConsumeTask)new ConsumeTask(this, singleListener, multiListener).execute(purchases.toArray(new Purchase[purchases.size()]));
    }

    private void logDebug(String msg) {
        if (this.mDebugLog) {
            Log.d((String)this.mDebugTag, (String)msg);
        }
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    private void logError(String msg, Throwable t) {
        Log.e((String)this.mDebugTag, (String)("In-app billing error: " + msg), (Throwable)t);
    }

    private void logWarn(String msg) {
        Log.w((String)this.mDebugTag, (String)("In-app billing warning: " + msg));
    }

    IInAppBillingService getInAppBillingService(IBinder service) {
        return IInAppBillingService.Stub.asInterface((IBinder)service);
    }

    private class BillingServiceConnection
    implements ServiceConnection {
        private OnIabSetupFinishedListener listener;

        BillingServiceConnection(OnIabSetupFinishedListener listener) {
            this.listener = listener;
        }

        public void onServiceDisconnected(ComponentName name) {
            IabHelper.this.logDebug("Billing service disconnected.");
            IabHelper.this.mService = null;
            this.listener = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (IabHelper.this.isDisposed()) {
                return;
            }
            IabHelper.this.logDebug("Billing service connected.");
            IabHelper.this.mService = IabHelper.this.getInAppBillingService(service);
            String packageName = IabHelper.this.mContext.getPackageName();
            IabResult result = new IabResult(Response.OK);
            try {
                IabHelper.this.logDebug("Checking for in-app billing 3 support.");
                int response = IabHelper.this.mService.isBillingSupported(3, packageName, ItemType.INAPP.toString());
                if (response == Response.OK.code) {
                    IabHelper.this.logDebug("In-app billing version 3 supported for " + packageName);
                    IabHelper.this.mInAppSupported = true;
                    IabHelper.this.logDebug("Checking for in-app billing 3 subscription support.");
                    response = IabHelper.this.mService.isBillingSupported(3, packageName, ItemType.SUBS.toString());
                    if (response == Response.OK.code) {
                        IabHelper.this.logDebug("Subscriptions AVAILABLE.");
                        IabHelper.this.mSubscriptionsSupported = true;
                    } else {
                        IabHelper.this.logDebug("Subscriptions NOT AVAILABLE. Response: " + response + " " + Response.getDescription(response));
                    }
                } else {
                    result = new IabResult(response, null);
                }
            }
            catch (RemoteException e) {
                result = new IabResult(Response.IABHELPER_REMOTE_EXCEPTION);
                Log.e((String)IabHelper.this.mDebugTag, (String)"RemoteException while setting up in-app billing.", (Throwable)e);
            }
            finally {
                IabHelper.this.mSetupDone = true;
                if (this.listener != null) {
                    this.listener.onIabSetupFinished(result);
                }
            }
        }
    }
}

