/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me;

import android.os.AsyncTask;
import com.github.jberkel.pay.me.IabException;
import com.github.jberkel.pay.me.IabHelper;
import com.github.jberkel.pay.me.IabResult;
import com.github.jberkel.pay.me.Response;
import com.github.jberkel.pay.me.listener.OnConsumeFinishedListener;
import com.github.jberkel.pay.me.listener.OnConsumeMultiFinishedListener;
import com.github.jberkel.pay.me.model.Purchase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ConsumeTask
extends AsyncTask<Purchase, Void, List<IabResult>> {
    private final IabHelper mIabHelper;
    private final OnConsumeFinishedListener mSingleListener;
    private final OnConsumeMultiFinishedListener mMultiListener;
    private List<Purchase> mPurchases;

    public ConsumeTask(IabHelper iabHelper, OnConsumeFinishedListener singleListener, OnConsumeMultiFinishedListener multiListener) {
        this.mIabHelper = iabHelper;
        this.mSingleListener = singleListener;
        this.mMultiListener = multiListener;
    }

    protected void onPreExecute() {
        this.mIabHelper.flagStartAsync("consume");
    }

    protected List<IabResult> doInBackground(Purchase ... purchases) {
        if (purchases == null || purchases.length == 0) {
            throw new IllegalArgumentException("no purchases");
        }
        this.mPurchases = new ArrayList<Purchase>(purchases.length);
        Collections.addAll(this.mPurchases, purchases);
        ArrayList<IabResult> results = new ArrayList<IabResult>(purchases.length);
        for (Purchase purchase : purchases) {
            try {
                this.mIabHelper.consume(purchase);
                results.add(new IabResult(Response.OK, "Successful consume of sku " + purchase.getSku()));
            }
            catch (IabException ex) {
                results.add(ex.getResult());
            }
        }
        return results;
    }

    protected void onPostExecute(List<IabResult> results) {
        this.mIabHelper.flagEndAsync();
        if (this.mIabHelper.isDisposed() || this.isCancelled()) {
            return;
        }
        if (this.mSingleListener != null) {
            this.mSingleListener.onConsumeFinished(this.mPurchases.get(0), results.get(0));
        }
        if (this.mMultiListener != null) {
            this.mMultiListener.onConsumeMultiFinished(this.mPurchases, results);
        }
    }
}

