/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me.validator;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.github.jberkel.pay.me.validator.SignatureValidator;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class DefaultSignatureValidator
implements SignatureValidator {
    private static final String TAG = "IAB/DefaultSignatureValidator";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private final PublicKey mPublicKey;

    public DefaultSignatureValidator(String base64EncodedKey) {
        this.mPublicKey = DefaultSignatureValidator.generatePublicKey(base64EncodedKey);
    }

    @Override
    public boolean validate(String signedData, String signature) {
        if (TextUtils.isEmpty((CharSequence)signedData) || TextUtils.isEmpty((CharSequence)signature)) {
            Log.e((String)TAG, (String)"Purchase verification failed: missing data.");
            return false;
        }
        if (!this.verify(signedData, signature)) {
            Log.w((String)TAG, (String)"signature does not match data.");
            return false;
        }
        return true;
    }

    private boolean verify(String signedData, String signature) {
        byte[] decodedSig;
        try {
            decodedSig = Base64.decode((String)signature, (int)0);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Error decoding signature.");
            return false;
        }
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
            sig.initVerify(this.mPublicKey);
            sig.update(signedData.getBytes());
            if (!sig.verify(decodedSig)) {
                Log.e((String)TAG, (String)"Signature verification failed.");
                return false;
            }
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            Log.e((String)TAG, (String)"NoSuchAlgorithmException.");
        }
        catch (InvalidKeyException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
        }
        catch (SignatureException e) {
            Log.e((String)TAG, (String)"Signature exception.");
        }
        return false;
    }

    private static PublicKey generatePublicKey(String encodedPublicKey) {
        try {
            byte[] decodedKey = Base64.decode((String)encodedPublicKey, (int)0);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
            throw new IllegalArgumentException(e);
        }
    }
}

