/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me.model;

import android.text.TextUtils;
import com.github.jberkel.pay.me.model.ItemType;
import org.json.JSONException;
import org.json.JSONObject;

public class SkuDetails {
    private final String mSku;
    private final String mType;
    private final String mPrice;
    private final String mTitle;
    private final String mDescription;
    private String mJson;
    private final ItemType mItemType;
    private static final String PRODUCT_ID = "productId";
    private static final String TYPE = "type";
    private static final String PRICE = "price";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";

    public SkuDetails(String jsonSkuDetails) throws JSONException {
        this.mJson = jsonSkuDetails;
        JSONObject json = new JSONObject(this.mJson);
        this.mSku = json.optString(PRODUCT_ID);
        if (TextUtils.isEmpty((CharSequence)this.mSku)) {
            throw new JSONException("SKU cannot be empty");
        }
        this.mType = json.optString(TYPE);
        this.mPrice = json.optString(PRICE);
        this.mTitle = json.optString(TITLE);
        this.mDescription = json.optString(DESCRIPTION);
        this.mItemType = ItemType.fromString(this.mType);
    }

    SkuDetails(ItemType itemType, String sku, String price, String title, String description) {
        if (itemType == null) {
            throw new IllegalArgumentException("itemType cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)sku)) {
            throw new IllegalArgumentException("SKU cannot be empty");
        }
        this.mItemType = itemType;
        this.mType = itemType.toString();
        this.mSku = sku;
        this.mPrice = price;
        this.mTitle = title;
        this.mDescription = description;
    }

    public String getSku() {
        return this.mSku;
    }

    public String getPrice() {
        return this.mPrice;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getRawType() {
        return this.mType;
    }

    public ItemType getType() {
        return this.mItemType;
    }

    public String toString() {
        return "SkuDetails{mItemType='" + (Object)((Object)this.mItemType) + '\'' + ", mSku='" + this.mSku + '\'' + ", mType='" + this.mType + '\'' + ", mPrice='" + this.mPrice + '\'' + ", mTitle='" + this.mTitle + '\'' + ", mDescription='" + this.mDescription + '\'' + ", mJson='" + this.mJson + '\'' + '}';
    }

    public boolean isTestSku() {
        return this.mSku.startsWith("android.test.");
    }
}

