/*
 * Decompiled with CFR 0.152.
 */
package com.github.jberkel.pay.me.model;

import com.github.jberkel.pay.me.model.ItemType;
import com.github.jberkel.pay.me.model.Purchase;
import com.github.jberkel.pay.me.model.SkuDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Inventory {
    private final Map<String, SkuDetails> mSkuMap = new HashMap<String, SkuDetails>();
    private final Map<String, Purchase> mPurchaseMap = new HashMap<String, Purchase>();

    public SkuDetails getSkuDetails(String sku) {
        return this.mSkuMap.get(sku);
    }

    public Collection<SkuDetails> getSkuDetails() {
        return this.mSkuMap.values();
    }

    public Purchase getPurchase(String sku) {
        return this.mPurchaseMap.get(sku);
    }

    public boolean hasPurchase(String sku) {
        return this.mPurchaseMap.containsKey(sku);
    }

    public boolean hasDetails(String sku) {
        return this.mSkuMap.containsKey(sku);
    }

    public void erasePurchase(String sku) {
        this.mPurchaseMap.remove(sku);
    }

    public List<String> getAllOwnedSkus() {
        return new ArrayList<String>(this.mPurchaseMap.keySet());
    }

    public List<String> getAllOwnedSkus(ItemType itemType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Purchase p : this.mPurchaseMap.values()) {
            if (p.getItemType() != itemType) continue;
            result.add(p.getSku());
        }
        return result;
    }

    public List<Purchase> getAllPurchases() {
        return new ArrayList<Purchase>(this.mPurchaseMap.values());
    }

    public void addSkuDetails(SkuDetails d) {
        this.mSkuMap.put(d.getSku(), d);
    }

    public void addPurchase(Purchase p) {
        this.mPurchaseMap.put(p.getSku(), p);
    }

    public String toString() {
        return "Inventory{skus=" + this.mSkuMap.values() + ", purchases=" + this.mPurchaseMap.values() + '}';
    }
}

