package cayte.starter;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class StarterService extends IntentService {

    private static final String TAG = StarterService.class.getSimpleName();

    public StarterService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (CayteStarter.isStarer(this)) {
            StarterUtil.end(this);
            StarterUtil.start(this);
        }
        doStart(getApplicationContext());
    }

    public void doStart(Context context) {
        try {
            Log.i(CayteStarter.TAG, "Starter Service  Real Start");
            Intent intent = new Intent(CayteStarter.getServiceName(context));
            intent.setPackage(context.getPackageName());
            intent.putExtra(context.getPackageName(), true);
            context.startService(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
