/*
 * Decompiled with CFR 0.152.
 */
package cayte.starter;

import android.app.ActivityManager;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import cayte.starter.CayteStarter;
import cayte.starter.StarterAlarmUtil;
import java.util.ArrayList;

public class StarterService
extends IntentService {
    private static final String TAG = StarterService.class.getSimpleName();

    public StarterService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        if (CayteStarter.isAlarmStarer((Context)this)) {
            StarterAlarmUtil.end((Context)this);
            StarterAlarmUtil.start((Context)this);
        }
        this.doStart(this.getApplicationContext());
    }

    public void doStart(Context context) {
        Log.i((String)CayteStarter.TAG, (String)"Starter doStart");
        if (!this.isServiceWorked(context)) {
            try {
                Log.i((String)CayteStarter.TAG, (String)"Starter Real Start");
                Intent intent = new Intent(CayteStarter.getServiceName(context));
                intent.putExtra(context.getPackageName(), true);
                context.startService(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isServiceWorked(Context context) {
        String serviceName = CayteStarter.getServiceName(context);
        if (serviceName == null || serviceName.equals("")) {
            return true;
        }
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        ArrayList runningService = (ArrayList)mActivityManager.getRunningServices(10);
        for (int i = 0; i < runningService.size(); ++i) {
            String name = ((ActivityManager.RunningServiceInfo)runningService.get((int)i)).service.getClassName().toString();
            if (!name.equals(serviceName)) continue;
            return true;
        }
        return false;
    }
}

