package cayte.starter;

import java.util.ArrayList;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningServiceInfo;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class StarterService extends IntentService {

	private static final String TAG = StarterService.class.getSimpleName();

	public StarterService() {
		super(TAG);
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		if (CayteStarter.isAlarmStarer(this)) {
			StarterAlarmUtil.end(this);
			StarterAlarmUtil.start(this);
		}
		doStart(getApplicationContext());
	}

	public void doStart(Context context) {
		Log.i(CayteStarter.TAG, "Starter doStart");
		if (!isServiceWorked(context)) {
			try {
				Log.i(CayteStarter.TAG, "Starter Real Start");
				Intent intent = new Intent(CayteStarter.getServiceName(context));
				intent.putExtra(context.getPackageName(), true);
				context.startService(intent);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public boolean isServiceWorked(Context context) {
		String serviceName = CayteStarter.getServiceName(context);
		if (serviceName == null || serviceName.equals(""))
			return true;
		ActivityManager mActivityManager = ((ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE));
		ArrayList<RunningServiceInfo> runningService = (ArrayList<RunningServiceInfo>) mActivityManager
				.getRunningServices(10);
		for (int i = 0; i < runningService.size(); i++) {
			String name = runningService.get(i).service.getClassName().toString();
			if (name.equals(serviceName))
				return true;
		}
		return false;
	}

}
