/*
 * Decompiled with CFR 0.152.
 */
package com.franmontiel.persistentcookiejar;

import com.franmontiel.persistentcookiejar.ClearableCookieJar;
import com.franmontiel.persistentcookiejar.cache.CookieCache;
import com.franmontiel.persistentcookiejar.persistence.CookiePersistor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieJar
implements ClearableCookieJar {
    private CookieCache cache;
    private CookiePersistor persistor;

    public PersistentCookieJar(CookieCache cache, CookiePersistor persistor) {
        this.cache = cache;
        this.persistor = persistor;
        this.cache.addAll(persistor.loadAll());
    }

    private static List<Cookie> filterPersistentCookies(List<Cookie> cookies) {
        ArrayList<Cookie> persistentCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (!cookie.persistent()) continue;
            persistentCookies.add(cookie);
        }
        return persistentCookies;
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }

    public synchronized void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.cache.addAll(cookies);
        this.persistor.saveAll(PersistentCookieJar.filterPersistentCookies(cookies));
    }

    public synchronized List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> cookiesToRemove = new ArrayList<Cookie>();
        ArrayList<Cookie> validCookies = new ArrayList<Cookie>();
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            Cookie currentCookie = (Cookie)it.next();
            if (PersistentCookieJar.isCookieExpired(currentCookie)) {
                cookiesToRemove.add(currentCookie);
                it.remove();
                continue;
            }
            if (!currentCookie.matches(url)) continue;
            validCookies.add(currentCookie);
        }
        this.persistor.removeAll(cookiesToRemove);
        return validCookies;
    }

    @Override
    public synchronized void clearSession() {
        this.cache.clear();
        this.cache.addAll(this.persistor.loadAll());
    }

    @Override
    public synchronized void clear() {
        this.cache.clear();
        this.persistor.clear();
    }
}

