/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http.async;

import cayte.frame.http.CayteHttp;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteResponse;
import cayte.frame.http.CayteResponseType;
import cayte.frame.http.async.CayteHttpAsyncCallback;
import cayte.frame.http.async.CayteHttpAsyncHandler;
import cayte.frame.http.async.CayteHttpAsyncMode;
import cayte.frame.http.async.CayteHttpSession;
import cayte.frame.task.GenericThread;
import cayte.frame.task.TaskProgress;
import cayte.frame.task.TaskResult;
import java.io.File;
import java.util.Map;
import okhttp3.CookieJar;
import okhttp3.Headers;

public class CayteHttpThread
extends GenericThread<Object>
implements CayteHttpSession {
    protected CayteHttpAsyncMode MODE = CayteHttpAsyncMode.DEFAULT;
    protected CayteHttp http = null;
    protected CayteHttpAsyncHandler handler = null;

    public CayteHttpThread() {
        this(CayteHttpAsyncMode.DEFAULT);
    }

    public CayteHttpThread(CayteHttpAsyncMode MODE) {
        super(new Object[0]);
        this.MODE = MODE;
        this.http = CayteHttp.create();
        this.handler = new CayteHttpAsyncHandler();
    }

    public static CayteHttpThread create() {
        return new CayteHttpThread();
    }

    public static CayteHttpThread create(CayteHttpAsyncMode MODE) {
        return new CayteHttpThread(MODE);
    }

    public CayteHttpThread setCallback(CayteHttpAsyncCallback callback) {
        callback.setHttpSession(this);
        this.handler.setCallback(callback);
        return this;
    }

    public CayteHttp getCayteHttp() {
        return this.http;
    }

    public CayteHttpThread url(String url) {
        this.http.url(url);
        return this;
    }

    public CayteHttpThread connectTimeout(int connectTimeout) {
        this.http.connectTimeout(connectTimeout);
        return this;
    }

    public CayteHttpThread writeTimeout(int writeTimeout) {
        this.http.writeTimeout(writeTimeout);
        return this;
    }

    public CayteHttpThread readTimeout(int readTimeout) {
        this.http.readTimeout(readTimeout);
        return this;
    }

    public CayteHttpThread requestCharsetName(String requestCharsetName) {
        this.http.requestCharsetName(requestCharsetName);
        return this;
    }

    public CayteHttpThread responseCharsetName(String responseCharsetName) {
        this.http.responseCharsetName(responseCharsetName);
        return this;
    }

    public CayteHttpThread retryOnFail(boolean retryOnFail) {
        this.http.retryOnFail(retryOnFail);
        return this;
    }

    public CayteHttpThread postEncoded(boolean postEncoded) {
        this.http.postEncoded(postEncoded);
        return this;
    }

    public CayteHttpThread cookieManager(CookieJar cookieJar) {
        this.http.cookieJar(cookieJar);
        return this;
    }

    @Override
    public CookieJar getSession() {
        return this.http.getSession();
    }

    @Override
    public void setSession(CookieJar session) {
        this.http.setSession(session);
    }

    public Headers.Builder getHeaders() {
        return this.http.getHeaders();
    }

    public CayteHttpThread setHeaders(Headers.Builder headers) {
        this.http.setHeaders(headers);
        return this;
    }

    public CayteHttpThread addHead(String name, String value) {
        this.http.addHead(name, value);
        return this;
    }

    public CayteHttpThread setHead(String name, String value) {
        this.http.setHead(name, value);
        return this;
    }

    public CayteHttpThread removeHead(String name) {
        this.http.removeHead(name);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.http.getParams();
    }

    public CayteHttpThread add(String name, Object value) {
        this.http.add(name, value);
        return this;
    }

    public CayteHttpThread addAll(Map<String, Object> params) {
        this.http.addAll(params);
        return this;
    }

    public CayteHttpThread set(Map<String, Object> params) {
        this.http.set(params);
        return this;
    }

    public CayteHttpThread clear() {
        this.http.clear();
        return this;
    }

    public CayteHttpThread content(String content) {
        this.http.content(content);
        return this;
    }

    public CayteHttpThread file(File file) {
        this.http.file(file);
        return this;
    }

    public CayteHttpThread download(String path) {
        this.http.download(path);
        return this;
    }

    public CayteHttpThread responseType(CayteResponseType responseType) {
        this.http.responseType(responseType);
        return this;
    }

    public CayteHttpThread requestProgress(final CayteProgress requestProgress) {
        this.http.requestProgress(new CayteProgress(){

            @Override
            public void progress(long progress, long length, int state) {
                if (requestProgress != null) {
                    requestProgress.progress(progress, length, state);
                }
                TaskProgress taskProgress = new TaskProgress();
                taskProgress.progress = progress;
                taskProgress.length = length;
                taskProgress.setInteger(Integer.valueOf(state));
                CayteHttpThread.this.publishProgress(new TaskProgress[]{taskProgress});
            }
        });
        return this;
    }

    public CayteHttpThread responseProgress(final CayteProgress responseProgress) {
        this.http.responseProgress(new CayteProgress(){

            @Override
            public void progress(long progress, long length, int state) {
                if (responseProgress != null) {
                    responseProgress.progress(progress, length, state);
                }
                TaskProgress taskProgress = new TaskProgress();
                taskProgress.progress = progress;
                taskProgress.length = length;
                taskProgress.setInteger(Integer.valueOf(state));
                CayteHttpThread.this.publishProgress(new TaskProgress[]{taskProgress});
            }
        });
        return this;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.handler.PRE();
    }

    protected CayteResponse doHttp() {
        if (this.MODE == CayteHttpAsyncMode.DEFAULT) {
            this.MODE = CayteHttp.DEFAULT_HTTP_MODE;
        }
        switch (this.MODE) {
            case GET: {
                return this.http.get().response();
            }
            case POST: {
                return this.http.post().response();
            }
            case JSON: {
                return this.http.postJson().response();
            }
            case OCTET: {
                return this.http.postOctet().response();
            }
            case MULTIPART: {
                return this.http.multipart().response();
            }
            case UP_OCTET: {
                return this.http.uploadOctet().response();
            }
        }
        return null;
    }

    protected TaskResult _doInBackground(Object ... params) {
        TaskResult result = new TaskResult();
        CayteResponse response = this.doHttp();
        result.success = true;
        result.setInteger(Integer.valueOf(response.code()));
        result.setString(response.message());
        result.setObject(response.content());
        return result;
    }

    protected void onProgressUpdate(TaskProgress ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.handler == null || values[i] == null) continue;
            this.handler.PROGRESS(values[i].progress, values[i].length, values[i].getInteger());
        }
    }

    protected void onPostExecute(TaskResult result) {
        super.onPostExecute(result);
        this.handler.POST();
        this.handler.CALLBACK(result);
    }

    protected void onCancelled() {
        super.onCancelled();
        this.handler.CANCEL();
    }

    public void cancel() {
        try {
            super.cancel();
            if (this.http != null) {
                this.http.close();
            }
            this.http = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

