/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http.async;

import cayte.frame.http.CayteHttp;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteResponse;
import cayte.frame.http.CayteResponseType;
import cayte.frame.http.async.CayteHttpAsyncCallback;
import cayte.frame.http.async.CayteHttpAsyncHandler;
import cayte.frame.http.async.CayteHttpAsyncMode;
import cayte.frame.http.async.CayteHttpSession;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskProgress;
import cayte.frame.task.TaskResult;
import java.io.File;
import java.util.Map;
import okhttp3.CookieJar;
import okhttp3.Headers;

public class CayteHttpTask
extends GenericTask<Object>
implements CayteHttpSession {
    protected CayteHttpAsyncMode MODE = CayteHttpAsyncMode.DEFAULT;
    protected CayteHttp http = null;
    protected CayteHttpAsyncHandler handler = null;

    public CayteHttpTask() {
        this(CayteHttpAsyncMode.DEFAULT);
    }

    public CayteHttpTask(CayteHttpAsyncMode MODE) {
        this.MODE = MODE;
        this.http = CayteHttp.create();
        this.handler = new CayteHttpAsyncHandler();
    }

    public static CayteHttpTask create() {
        return new CayteHttpTask();
    }

    public static CayteHttpTask create(CayteHttpAsyncMode MODE) {
        return new CayteHttpTask(MODE);
    }

    public CayteHttpTask setCallback(CayteHttpAsyncCallback callback) {
        callback.setHttpSession(this);
        this.handler.setCallback(callback);
        return this;
    }

    public CayteHttp getCayteHttp() {
        return this.http;
    }

    public CayteHttpTask url(String url) {
        this.http.url(url);
        return this;
    }

    public CayteHttpTask connectTimeout(int connectTimeout) {
        this.http.connectTimeout(connectTimeout);
        return this;
    }

    public CayteHttpTask writeTimeout(int writeTimeout) {
        this.http.writeTimeout(writeTimeout);
        return this;
    }

    public CayteHttpTask readTimeout(int readTimeout) {
        this.http.readTimeout(readTimeout);
        return this;
    }

    public CayteHttpTask requestCharsetName(String requestCharsetName) {
        this.http.requestCharsetName(requestCharsetName);
        return this;
    }

    public CayteHttpTask responseCharsetName(String responseCharsetName) {
        this.http.responseCharsetName(responseCharsetName);
        return this;
    }

    public CayteHttpTask retryOnFail(boolean retryOnFail) {
        this.http.retryOnFail(retryOnFail);
        return this;
    }

    public CayteHttpTask postEncoded(boolean postEncoded) {
        this.http.postEncoded(postEncoded);
        return this;
    }

    public CayteHttpTask cookieManager(CookieJar cookieJar) {
        this.http.cookieJar(cookieJar);
        return this;
    }

    @Override
    public CookieJar getSession() {
        return this.http.getSession();
    }

    @Override
    public void setSession(CookieJar session) {
        this.http.setSession(session);
    }

    public Headers.Builder getHeaders() {
        return this.http.getHeaders();
    }

    public CayteHttpTask setHeaders(Headers.Builder headers) {
        this.http.setHeaders(headers);
        return this;
    }

    public CayteHttpTask addHead(String name, String value) {
        this.http.addHead(name, value);
        return this;
    }

    public CayteHttpTask setHead(String name, String value) {
        this.http.setHead(name, value);
        return this;
    }

    public CayteHttpTask removeHead(String name) {
        this.http.removeHead(name);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.http.getParams();
    }

    public CayteHttpTask add(String name, Object value) {
        this.http.add(name, value);
        return this;
    }

    public CayteHttpTask addAll(Map<String, Object> params) {
        this.http.addAll(params);
        return this;
    }

    public CayteHttpTask set(Map<String, Object> params) {
        this.http.set(params);
        return this;
    }

    public CayteHttpTask clear() {
        this.http.clear();
        return this;
    }

    public CayteHttpTask content(String content) {
        this.http.content(content);
        return this;
    }

    public CayteHttpTask file(File file) {
        this.http.file(file);
        return this;
    }

    public CayteHttpTask download(String path) {
        this.http.download(path);
        return this;
    }

    public CayteHttpTask responseType(CayteResponseType responseType) {
        this.http.responseType(responseType);
        return this;
    }

    public CayteHttpTask requestProgress(final CayteProgress requestProgress) {
        this.http.requestProgress(new CayteProgress(){

            @Override
            public void progress(long progress, long length, int state) {
                if (requestProgress != null) {
                    requestProgress.progress(progress, length, state);
                }
                TaskProgress taskProgress = new TaskProgress();
                taskProgress.progress = progress;
                taskProgress.length = length;
                taskProgress.setInteger(Integer.valueOf(state));
                CayteHttpTask.this.publishProgress(new TaskProgress[]{taskProgress});
            }
        });
        return this;
    }

    public CayteHttpTask responseProgress(final CayteProgress responseProgress) {
        this.http.responseProgress(new CayteProgress(){

            @Override
            public void progress(long progress, long length, int state) {
                if (responseProgress != null) {
                    responseProgress.progress(progress, length, state);
                }
                TaskProgress taskProgress = new TaskProgress();
                taskProgress.progress = progress;
                taskProgress.length = length;
                taskProgress.setInteger(Integer.valueOf(state));
                CayteHttpTask.this.publishProgress(new TaskProgress[]{taskProgress});
            }
        });
        return this;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.handler.PRE();
    }

    protected CayteResponse doHttp() {
        if (this.MODE == CayteHttpAsyncMode.DEFAULT) {
            this.MODE = CayteHttp.DEFAULT_HTTP_MODE;
        }
        switch (this.MODE) {
            case GET: {
                return this.http.get().response();
            }
            case POST: {
                return this.http.post().response();
            }
            case JSON: {
                return this.http.postJson().response();
            }
            case OCTET: {
                return this.http.postOctet().response();
            }
            case MULTIPART: {
                return this.http.multipart().response();
            }
            case UP_OCTET: {
                return this.http.uploadOctet().response();
            }
        }
        return null;
    }

    protected TaskResult _doInBackground(Object ... params) {
        TaskResult result = new TaskResult();
        CayteResponse response = this.doHttp();
        result.success = true;
        result.setInteger(Integer.valueOf(response.code()));
        result.setString(response.message());
        result.setObject(response.content());
        return result;
    }

    protected void onProgressUpdate(TaskProgress ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (this.handler == null || values[i] == null) continue;
            this.handler.PROGRESS(values[i].progress, values[i].length, values[i].getInteger());
        }
    }

    protected void onPostExecute(TaskResult result) {
        super.onPostExecute(result);
        this.handler.POST();
        this.handler.CALLBACK(result);
    }

    protected void onCancelled() {
        super.onCancelled();
        this.handler.CANCEL();
    }

    public void cancel() {
        try {
            this.cancel(true);
            if (this.http != null) {
                this.http.close();
            }
            this.http = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

