/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http.async;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import cayte.frame.http.async.CayteHttpAsyncCallback;
import cayte.frame.task.TaskResult;

public class CayteHttpAsyncHandler
extends Handler {
    public static final int W_PRE = 333;
    public static final int W_PROGRESS = 334;
    public static final int W_POST = 335;
    public static final int W_CANCEL = 336;
    public static final int W_CALLBACK = 337;
    private CayteHttpAsyncCallback callback = null;

    public void setCallback(CayteHttpAsyncCallback callback) {
        this.callback = callback;
    }

    public void PRE() {
        Message msg = this.obtainMessage(333);
        this.sendMessage(msg);
    }

    public void PROGRESS(long progress, long length, int state) {
        Message msg = this.obtainMessage(334);
        Bundle data = new Bundle();
        data.putLong("progress", progress);
        data.putLong("length", length);
        data.putInt("state", state);
        msg.setData(data);
        this.sendMessage(msg);
    }

    public void POST() {
        Message msg = this.obtainMessage(335);
        this.sendMessage(msg);
    }

    public void CANCEL() {
        Message msg = this.obtainMessage(336);
        this.sendMessage(msg);
    }

    public void CALLBACK(TaskResult result) {
        Message msg = this.obtainMessage(337);
        msg.obj = result;
        this.sendMessage(msg);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 333: {
                if (this.callback == null) break;
                this.callback.onPreHttp();
                break;
            }
            case 334: {
                Bundle data = msg.getData();
                long progress = data.getLong("progress", 0L);
                long length = data.getLong("length", -1L);
                int state = data.getInt("state");
                if (this.callback == null) break;
                this.callback.onProgress(progress, length, state);
                break;
            }
            case 335: {
                if (this.callback == null) break;
                this.callback.onPostHttp();
                break;
            }
            case 336: {
                if (this.callback == null) break;
                this.callback.onCancelHttp();
                break;
            }
            case 337: {
                TaskResult result = (TaskResult)msg.obj;
                if (this.callback == null) break;
                this.callback.onCallback(result.getInteger(), result.getString(), result.getObject());
                break;
            }
        }
    }
}

