/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteFormBuilder;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteRequestBody;
import cayte.frame.http.CayteResponse;
import cayte.frame.http.CayteResponseType;
import cayte.frame.http.async.CayteHttpAsyncMode;
import cayte.frame.log.D;
import java.io.File;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CayteHttp {
    public static final String TAG = CayteHttp.class.getSimpleName();
    public static int DEFAULT_CONNECTTIMEOUT = 5;
    public static int DEFAULT_WRITETIMEOUT = 15;
    public static int DEFAULT_READTIMEOUT = 15;
    public static String DEFAULT_CHARSETNAME = "utf-8";
    public static boolean DEFAULT_RETRY_FAIL = false;
    public static boolean DEFAULT_POST_ENCODED = false;
    public static CayteHttpAsyncMode DEFAULT_HTTP_MODE = CayteHttpAsyncMode.POST;
    public static CookieJar DEFAULT_COOKIE_JAR = null;
    private OkHttpClient client = null;
    private Call call = null;
    private String url = null;
    private int connectTimeout = DEFAULT_CONNECTTIMEOUT;
    private int writeTimeout = DEFAULT_WRITETIMEOUT;
    private int readTimeout = DEFAULT_READTIMEOUT;
    private String requestCharsetName = DEFAULT_CHARSETNAME;
    private String responseCharsetName = DEFAULT_CHARSETNAME;
    private boolean retryOnFail = DEFAULT_RETRY_FAIL;
    private boolean postEncoded = DEFAULT_POST_ENCODED;
    private CookieJar cookieJar = DEFAULT_COOKIE_JAR;
    private Headers.Builder headers = new Headers.Builder();
    private Map<String, Object> params = new HashMap<String, Object>();
    private String content = null;
    private File file = null;
    private Request request = null;
    private CayteProgress requestProgress;
    private Response response = null;
    private CayteProgress responseProgress;
    private CayteResponseType responseType = CayteResponseType.STRING;
    private String path = null;
    private CayteResponse cayteResponse = null;
    private CookieJar session = null;
    private Throwable e = null;

    public CayteHttp() {
        D.i((String)TAG, (String)"connect create");
    }

    public static CayteHttp create() {
        return new CayteHttp();
    }

    public static String decoding(String encode, String fromCharsetName, String toCharsetName) {
        try {
            return new String(encode.getBytes(fromCharsetName), toCharsetName);
        }
        catch (Exception e) {
            return encode;
        }
    }

    public static String getMimeType4URLConnection(String path) {
        try {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String type = fileNameMap.getContentTypeFor(path);
            if (type == null) {
                return "application/octet-stream";
            }
            return type;
        }
        catch (Exception e) {
            return "application/octet-stream";
        }
    }

    public CayteHttp url(String url) {
        this.url = url;
        D.i((String)TAG, (String)("connect url : " + url.toString()));
        return this;
    }

    public CayteHttp connectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
        D.i((String)TAG, (String)("client connectTimeout : " + connectTimeout));
        return this;
    }

    public CayteHttp writeTimeout(int writeTimeout) {
        if (writeTimeout > 0) {
            this.writeTimeout = writeTimeout;
        }
        D.i((String)TAG, (String)("client writeTimeout : " + writeTimeout));
        return this;
    }

    public CayteHttp readTimeout(int readTimeout) {
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
        D.i((String)TAG, (String)("client readTimeout : " + readTimeout));
        return this;
    }

    public CayteHttp requestCharsetName(String requestCharsetName) {
        this.requestCharsetName = requestCharsetName;
        D.i((String)TAG, (String)("client requestCharsetName : " + requestCharsetName));
        return this;
    }

    public CayteHttp responseCharsetName(String responseCharsetName) {
        this.responseCharsetName = responseCharsetName;
        D.i((String)TAG, (String)("client responseCharsetName : " + responseCharsetName));
        return this;
    }

    public CayteHttp retryOnFail(boolean retryOnFail) {
        this.retryOnFail = retryOnFail;
        D.i((String)TAG, (String)("client retryOnFail : " + retryOnFail));
        return this;
    }

    public CayteHttp postEncoded(boolean postEncoded) {
        this.postEncoded = postEncoded;
        D.i((String)TAG, (String)("client postEncoded : " + postEncoded));
        return this;
    }

    public CayteHttp cookieJar(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        D.i((String)TAG, (String)"client cookieJar");
        return this;
    }

    public CayteHttp requestProgress(CayteProgress requestProgress) {
        this.requestProgress = requestProgress;
        return this;
    }

    public CayteHttp responseProgress(CayteProgress responseProgress) {
        this.responseProgress = responseProgress;
        return this;
    }

    public CayteHttp responseType(CayteResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    public CayteHttp download(String path) {
        this.path = path;
        return this;
    }

    private void createClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
        builder.writeTimeout((long)this.writeTimeout, TimeUnit.SECONDS);
        builder.readTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(this.retryOnFail);
        if (this.session == null) {
            if (this.cookieJar != null) {
                builder.cookieJar(this.cookieJar);
            }
        } else {
            builder.cookieJar(this.session);
        }
        this.client = builder.build();
    }

    public void close() {
        this.close(null);
    }

    public void close(Throwable e) {
        this.e = e;
        if (this.cayteResponse != null) {
            this.cayteResponse.close();
        }
        if (this.call != null) {
            this.call.cancel();
        }
        this.call = null;
        this.client = null;
    }

    private void doRequest() throws Exception {
        this.call = this.client.newCall(this.request);
        this.response = this.call.execute();
    }

    public CayteHttp get() {
        D.i((String)TAG, (String)"get");
        try {
            this.createClient();
            this.request = new Request.Builder().url(this.url).headers(this.headers.build()).build();
            this.doRequest();
            D.i((String)TAG, (String)"get finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("get Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public Headers.Builder getHeaders() {
        return this.headers;
    }

    public CayteHttp setHeaders(Headers.Builder headers) {
        this.headers = headers;
        return this;
    }

    public CayteHttp addHead(String name, String value) {
        this.headers.add(name, value);
        return this;
    }

    public CayteHttp setHead(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public CayteHttp removeHead(String name) {
        this.headers.removeAll(name);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public CayteHttp add(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public CayteHttp addAll(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public CayteHttp set(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public CayteHttp clear() {
        this.params.clear();
        return this;
    }

    public CayteHttp content(String content) {
        this.content = content;
        return this;
    }

    public CayteHttp file(File file) {
        this.file = file;
        return this;
    }

    public CayteHttp post() {
        D.i((String)TAG, (String)"post");
        try {
            CayteFormBuilder formBuilder = new CayteFormBuilder(this.requestCharsetName);
            if (this.params != null && !this.params.isEmpty()) {
                for (String key : this.params.keySet()) {
                    Object object = this.params.get(key);
                    if (object == null || object instanceof File) continue;
                    D.d((String)TAG, (String)("params :" + key + "=" + object.toString()));
                    if (this.postEncoded) {
                        formBuilder.addEncoded(key, object.toString());
                        continue;
                    }
                    formBuilder.add(key, object.toString());
                }
            }
            RequestBody body = formBuilder.build();
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).headers(this.headers.build()).post(body).build();
            this.doRequest();
            D.i((String)TAG, (String)"post finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("post Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp post(String contentType) {
        D.i((String)TAG, (String)("request : " + contentType));
        try {
            D.d((String)TAG, (String)("content :" + this.content.toString()));
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)(contentType.toString() + ";charset=" + this.requestCharsetName)), (String)this.content);
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).headers(this.headers.build()).post(body).build();
            this.doRequest();
            D.i((String)TAG, (String)"request finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("request Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp upload(String contentType) {
        D.i((String)TAG, (String)("request : " + contentType));
        try {
            D.d((String)TAG, (String)("file :" + this.file.getAbsolutePath()));
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)contentType.toString()), (File)this.file);
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).headers(this.headers.build()).post(body).build();
            this.doRequest();
            D.i((String)TAG, (String)"request finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("request Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp multipart() {
        D.i((String)TAG, (String)"multipart");
        try {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (this.params != null && !this.params.isEmpty()) {
                for (String key : this.params.keySet()) {
                    Object object = this.params.get(key);
                    if (object == null) continue;
                    if (object instanceof File) {
                        File file = (File)object;
                        D.d((String)TAG, (String)("params :" + key + "=" + file.getAbsolutePath()));
                        MediaType mediaType = MediaType.parse((String)CayteHttp.getMimeType4URLConnection(file.getAbsolutePath()));
                        builder.addFormDataPart(key, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
                        continue;
                    }
                    if (object instanceof File[]) {
                        File[] files;
                        for (File file : files = (File[])object) {
                            D.d((String)TAG, (String)("params :" + key + "=" + file.getAbsolutePath()));
                            MediaType mediaType = MediaType.parse((String)CayteHttp.getMimeType4URLConnection(file.getAbsolutePath()));
                            builder.addFormDataPart(key, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
                        }
                        continue;
                    }
                    String content = object.toString();
                    D.d((String)TAG, (String)("params :" + key + "=" + content));
                    if (!this.postEncoded) {
                        content = URLEncoder.encode(content, this.requestCharsetName);
                    }
                    builder.addFormDataPart(key, content);
                }
            }
            Object body = builder.build();
            if (this.requestProgress != null) {
                body = CayteRequestBody.create((RequestBody)body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).headers(this.headers.build()).post((RequestBody)body).build();
            this.doRequest();
            D.i((String)TAG, (String)"multipart finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("multipart Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    private CookieJar getSession4Connection() {
        if (this.client != null) {
            return this.client.cookieJar();
        }
        return null;
    }

    public CookieJar getSession() {
        return this.session;
    }

    public void setSession(CookieJar session) {
        this.session = session;
    }

    public CayteResponse response() {
        try {
            if (this.client == null) {
                this.cayteResponse = this.e == null ? CayteResponse.createError(-4, "error : unknow") : (this.e instanceof ConnectException || this.e instanceof UnknownHostException ? CayteResponse.createError(-1, "error : network") : (this.e instanceof InterruptedIOException ? CayteResponse.createError(-5, "error : timeout") : CayteResponse.createError(-3, "error : " + this.e.getLocalizedMessage())));
                CayteResponse cayteResponse = this.cayteResponse;
                return cayteResponse;
            }
            this.session = this.getSession4Connection();
            this.cayteResponse = CayteResponse.create(this.response, this.responseType, this.responseCharsetName).path(this.path).read(this.responseProgress);
            D.i((String)TAG, (String)"response");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("response Exception : " + e.getMessage()), (Throwable)e);
            this.cayteResponse = CayteResponse.createError(-3, "error : " + e.getLocalizedMessage());
        }
        finally {
            this.close();
        }
        return this.cayteResponse;
    }

    public CayteHttp postOctet() {
        return this.post("application/octet-stream");
    }

    public CayteHttp postJson() {
        return this.post("application/json");
    }

    public CayteHttp uploadOctet() {
        return this.upload("application/octet-stream");
    }
}

