package cayte.frame.http;

import java.io.IOException;

import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class CayteResponseBody extends ResponseBody {

    private ResponseBody responseBody = null;
    private CayteProgress responseProgress = null;
    private BufferedSource bufferedSource = null;
    private long contentLength = 0L;

    public CayteResponseBody(ResponseBody responseBody, CayteProgress responseProgress) {
        this.responseBody = responseBody;
        this.responseProgress = responseProgress;
    }

    public static CayteResponseBody create(ResponseBody responseBody, CayteProgress responseProgress) {
        return new CayteResponseBody(responseBody, responseProgress);
    }

    @Override
    public long contentLength() {
        return responseBody.contentLength();
    }

    @Override
    public MediaType contentType() {
        return responseBody.contentType();
    }

    @Override
    public BufferedSource source() {
        if (bufferedSource == null) {
            contentLength = contentLength();
            if (responseProgress != null)
                responseProgress.progress(0, contentLength, -1);
            bufferedSource = Okio.buffer(source(responseBody.source()));
        }
        return bufferedSource;
    }

    private Source source(Source source) {

        return new ForwardingSource(source) {
            long totalBytesRead = 0L;

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                totalBytesRead += bytesRead != -1 ? bytesRead : 0;
                if (responseProgress != null)
                    responseProgress.progress(totalBytesRead, contentLength, bytesRead == -1 ? 1 : 0);
                return bytesRead;
            }
        };
    }

}
