/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteHttp;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteResponseBody;
import cayte.frame.http.CayteResponseType;
import cayte.frame.log.D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CayteResponse {
    public static final int ERR_NETWORK = -1;
    public static final int ERR_SERVER = -2;
    public static final int ERR_EXCEPTION = -3;
    public static final int ERR_UNKNOW = -4;
    public static final int ERR_TIMEOUT = -5;
    private String charsetName = CayteHttp.DEFAULT_CHARSETNAME;
    private Response response = null;
    private CayteResponseType responseType = CayteResponseType.STRING;
    private String path = null;
    private int code = -1;
    private String message = null;
    private ResponseBody responseBody = null;
    private InputStream in = null;
    private OutputStream out = null;
    private FileThread fileThread;
    private Object content = null;

    public CayteResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public CayteResponse(Response response, CayteResponseType responseType, String charsetName) {
        this.response = response;
        this.responseType = responseType;
        this.charsetName = charsetName;
    }

    public static CayteResponse createError(int code, String message) {
        return new CayteResponse(code, message);
    }

    public static CayteResponse create(Response response, CayteResponseType responseType, String charsetName) {
        return new CayteResponse(response, responseType, charsetName);
    }

    public Response response() {
        return this.response;
    }

    public boolean success() {
        return this.response != null && this.code == 200;
    }

    public CayteResponse path(String path) {
        this.path = path;
        return this;
    }

    public CayteResponse read() {
        return this.read(null);
    }

    public CayteResponse read(CayteProgress responseProgress) {
        this.readStatus();
        if (this.success()) {
            this.responseBody = this.response.body();
            if (responseProgress != null) {
                this.responseBody = CayteResponseBody.create(this.responseBody, responseProgress);
            }
            this.readContent();
        }
        return this;
    }

    public <T> T content() {
        return (T)(this.content == null ? null : this.content);
    }

    private void readStatus() {
        if (this.response == null) {
            this.code = -4;
            this.message = "error : unknown";
            return;
        }
        if (!this.response.isSuccessful()) {
            this.code = this.response.code() > 0 ? this.response.code() : -2;
            this.message = this.response.message() == null ? "error : server" : this.response.message();
            return;
        }
        this.code = this.response.code();
        this.message = this.response.message();
        D.d((String)CayteHttp.TAG, (String)("response code : " + this.code));
        D.d((String)CayteHttp.TAG, (String)("response message : " + this.message));
    }

    private void readContent() {
        switch (this.responseType) {
            case BYTES: {
                this.content = this.bytes();
                break;
            }
            default: {
                this.content = this.string();
                break;
            }
            case FILE: {
                this.content = this.file(this.path);
            }
        }
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    private byte[] bytes() {
        if (this.responseBody == null) {
            D.e((String)CayteHttp.TAG, (String)"Exception : is not success");
            return null;
        }
        try {
            byte[] bytes = this.responseBody.bytes();
            D.d((String)CayteHttp.TAG, (String)("response bytes : " + bytes.length));
            return bytes;
        }
        catch (Exception e) {
            this.code = -3;
            this.message = "error : " + e.getLocalizedMessage();
            D.e((String)CayteHttp.TAG, (String)("bytes Exception : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private String string() {
        if (this.responseBody == null) {
            D.e((String)CayteHttp.TAG, (String)"Exception : is not success");
            return null;
        }
        try {
            String string = new String(this.responseBody.bytes(), this.charsetName);
            D.d((String)CayteHttp.TAG, (String)("response content : " + string));
            return string;
        }
        catch (Exception e) {
            this.code = -3;
            this.message = "error : " + e.getLocalizedMessage();
            D.e((String)CayteHttp.TAG, (String)("content Exception : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private File file(String path) {
        if (this.responseBody == null) {
            D.e((String)CayteHttp.TAG, (String)"Exception : is not success");
            return null;
        }
        try {
            this.in = this.responseBody.byteStream();
            File tempFile = new File(path + ".temp");
            if (tempFile.exists()) {
                tempFile.delete();
            }
            tempFile.createNewFile();
            this.out = new FileOutputStream(tempFile);
            this.fileThread = new FileThread();
            this.fileThread.start();
            this.fileThread.join();
            if (this.fileThread.isInterrupted() || this.fileThread.isException()) {
                this.clearFile(path);
                this.code = -3;
                D.e((String)CayteHttp.TAG, (String)("file Exception : " + this.fileThread.getException().getMessage()), (Throwable)this.fileThread.getException());
                return null;
            }
            File file = new File(path);
            tempFile.renameTo(file);
            D.d((String)CayteHttp.TAG, (String)("response file : " + file.getAbsolutePath()));
            return file;
        }
        catch (Exception e) {
            this.code = -3;
            this.message = "error : " + e.getLocalizedMessage();
            D.e((String)CayteHttp.TAG, (String)("file Exception : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void interruptThread() {
        if (this.fileThread != null && this.fileThread.getState() != Thread.State.TERMINATED) {
            this.fileThread.interrupt();
        }
    }

    private void clearFile(String path) {
        new File(path + ".temp").delete();
        new File(path).delete();
    }

    public void close() {
        this.interruptThread();
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FileThread
    extends Thread {
        private boolean isException = false;
        private Exception exception = null;

        private FileThread() {
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[8192];
                int n = 0;
                while (!this.isInterrupted() && (n = CayteResponse.this.in.read(buffer)) != -1) {
                    CayteResponse.this.out.write(buffer, 0, n);
                    CayteResponse.this.out.flush();
                }
            }
            catch (Exception e) {
                this.exception = e;
                this.isException = true;
            }
            finally {
                CayteResponse.this.close();
            }
        }

        public boolean isException() {
            return this.isException;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

