package cayte.frame.http.async;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import cayte.frame.task.TaskResult;

public class CayteHttpAsyncHandler extends Handler {

    public static final int W_PRE = 333;
    public static final int W_PROGRESS = 334;
    public static final int W_POST = 335;
    public static final int W_CANCEL = 336;
    public static final int W_CALLBACK = 337;

    private CayteHttpAsyncCallback callback = null;

    public void setCallback(CayteHttpAsyncCallback callback) {
        this.callback = callback;
    }

    public void PRE() {
        Message msg = obtainMessage(W_PRE);
        sendMessage(msg);
    }

    public void PROGRESS(long progress, long length, int state) {
        Message msg = obtainMessage(W_PROGRESS);
        Bundle data = new Bundle();
        data.putLong("progress", progress);
        data.putLong("length", length);
        data.putInt("state", state);
        msg.setData(data);
        sendMessage(msg);
    }

    public void POST() {
        Message msg = obtainMessage(W_POST);
        sendMessage(msg);
    }

    public void CANCEL() {
        Message msg = obtainMessage(W_CANCEL);
        sendMessage(msg);
    }

    public void CALLBACK(TaskResult result) {
        Message msg = obtainMessage(W_CALLBACK);
        msg.obj = result;
        sendMessage(msg);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case W_PRE:
                if (callback != null)
                    callback.onPreHttp();
                break;
            case W_PROGRESS:
                Bundle data = msg.getData();
                long progress = data.getLong("progress", 0);
                long length = data.getLong("length", -1);
                int state = data.getInt("state");
                if (callback != null)
                    callback.onProgress(progress, length, state);
                break;
            case W_POST:
                if (callback != null)
                    callback.onPostHttp();
                break;
            case W_CANCEL:
                if (callback != null)
                    callback.onCancelHttp();
                break;
            case W_CALLBACK:
                TaskResult result = (TaskResult) msg.obj;
                if (callback != null) {
                    callback.onCallback(result.getInteger(), result.getString(), result.getObject());
                }
                break;
            default:
                break;
        }
    }

}
