/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CayteUrl {
    private String url;
    private Map<String, Object> params = null;

    public static CayteUrl with(String url) {
        return new CayteUrl(url);
    }

    public CayteUrl(String url) {
        this.url = url;
        this.params = new HashMap<String, Object>();
    }

    public CayteUrl add(String name, Object value) {
        return this.add(name, String.valueOf(value));
    }

    public CayteUrl add(String name, CharSequence value) {
        return this.add(name, value.toString());
    }

    public CayteUrl add(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public CayteUrl addAll(Map<String, Object> pairs) {
        this.params.putAll(pairs);
        return this;
    }

    public CayteUrl set(Map<String, Object> pairs) {
        this.params = pairs;
        return this;
    }

    public CayteUrl clear() {
        this.params.clear();
        return this;
    }

    private String display() {
        if (this.params == null || this.params.isEmpty()) {
            return this.url;
        }
        StringBuilder sb = new StringBuilder();
        Set<String> keys = this.params.keySet();
        for (String key : keys) {
            String value = this.params.get(key).toString();
            if (value == null) continue;
            if (sb.length() == 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(key + "=" + this.getEncoder(value));
        }
        return this.url + sb.toString();
    }

    private String getEncoder(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            return string;
        }
    }

    public String url() {
        return this.display();
    }
}

