/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteProgress;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class CayteRequestBody
extends RequestBody {
    private RequestBody requestBody;
    private CayteProgress requestProgress;
    private BufferedSink bufferedSink;
    private long contentLength = 0L;

    public static CayteRequestBody create(RequestBody requestBody, CayteProgress requestProgress) {
        return new CayteRequestBody(requestBody, requestProgress);
    }

    public CayteRequestBody(RequestBody requestBody, CayteProgress requestProgress) {
        this.requestBody = requestBody;
        this.requestProgress = requestProgress;
    }

    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.bufferedSink == null) {
            this.contentLength = this.contentLength();
            if (this.requestProgress != null) {
                this.requestProgress.progress(0L, this.contentLength, -1);
            }
            this.bufferedSink = Okio.buffer((Sink)this.sink((Sink)sink));
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }

    private Sink sink(Sink sink) {
        return new ForwardingSink(sink){
            long bytesWritten;
            {
                this.bytesWritten = 0L;
            }

            public void write(Buffer source, long byteCount) throws IOException {
                super.write(source, byteCount);
                this.bytesWritten += byteCount;
                if (CayteRequestBody.this.requestProgress != null) {
                    CayteRequestBody.this.requestProgress.progress(this.bytesWritten, CayteRequestBody.this.contentLength, this.bytesWritten == CayteRequestBody.this.contentLength ? 1 : 0);
                }
            }
        };
    }
}

