/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteHttp;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.ByteString;

public final class CayteFormBuilder {
    private static final String contentType = "application/x-www-form-urlencoded";
    private final Buffer content = new Buffer();
    private String charsetName = CayteHttp.DEFAULT_CHARSETNAME;

    public CayteFormBuilder(String charsetName) {
        this.charsetName = charsetName;
    }

    public CayteFormBuilder add(String name, String value) throws UnsupportedEncodingException {
        if (this.content.size() > 0L) {
            this.content.writeByte(38);
        }
        this.content.writeString(URLEncoder.encode(name, this.charsetName), Charset.forName(this.charsetName));
        this.content.writeByte(61);
        this.content.writeString(URLEncoder.encode(value, this.charsetName), Charset.forName(this.charsetName));
        return this;
    }

    public CayteFormBuilder addEncoded(String name, String value) {
        if (this.content.size() > 0L) {
            this.content.writeByte(38);
        }
        this.content.writeString(name, Charset.forName(this.charsetName));
        this.content.writeByte(61);
        this.content.writeString(value, Charset.forName(this.charsetName));
        return this;
    }

    public RequestBody build() {
        return RequestBody.create((MediaType)MediaType.parse((String)("application/x-www-form-urlencoded;charset=" + this.charsetName)), (ByteString)this.content.snapshot());
    }
}

