package cayte.frame.http.async;

import java.io.File;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.Map;

import cayte.frame.http.CayteHttp;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteResponse;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskProgress;
import cayte.frame.task.TaskResult;

public class CayteHttpTask extends GenericTask<Object> implements CayteHttpSession {

	protected CayteHttpAsyncMode MODE = CayteHttpAsyncMode.DEFAULT;

	protected CayteHttp http = null;

	protected CayteHttpAsyncHandler handler = null;

	public static CayteHttpTask create() {
		return new CayteHttpTask();
	}

	public static CayteHttpTask create(CayteHttpAsyncMode MODE) {
		return new CayteHttpTask(MODE);
	}

	public CayteHttpTask() {
		this(CayteHttpAsyncMode.DEFAULT);
	}

	public CayteHttpTask(CayteHttpAsyncMode MODE) {
		this.MODE = MODE;
		this.http = CayteHttp.create();
		this.handler = new CayteHttpAsyncHandler();
	}

	public CayteHttpTask setCallback(CayteHttpAsyncCallback callback) {
		callback.setHttpSession(this);
		this.handler.setCallback(callback);
		return this;
	}

	public CayteHttp getCayteHttp() {
		return http;
	}

	public CayteHttpTask url(String url) {
		http.url(url);
		return this;
	}

	public CayteHttpTask connectTimeout(int connectTimeout) {
		http.connectTimeout(connectTimeout);
		return this;
	}

	public CayteHttpTask writeTimeout(int writeTimeout) {
		http.writeTimeout(writeTimeout);
		return this;
	}

	public CayteHttpTask readTimeout(int readTimeout) {
		http.readTimeout(readTimeout);
		return this;
	}

	public CayteHttpTask requestCharsetName(String requestCharsetName) {
		http.requestCharsetName(requestCharsetName);
		return this;
	}

	public CayteHttpTask responseCharsetName(String responseCharsetName) {
		http.responseCharsetName(responseCharsetName);
		return this;
	}

	public CayteHttpTask retryOnFail(boolean retryOnFail) {
		http.retryOnFail(retryOnFail);
		return this;
	}

	public CayteHttpTask postEncoded(boolean postEncoded) {
		http.postEncoded(postEncoded);
		return this;
	}

	public CayteHttpTask cookieManager(CookieManager cookieManager) {
		http.cookieManager(cookieManager);
		return this;
	}

	@Override
	public void setSession(CookieHandler session) {
		http.setSession(session);
	}

	@Override
	public CookieHandler getSession() {
		return http.getSession();
	}

	public Map<String, Object> getParams() {
		return http.getParams();
	}

	public CayteHttpTask add(String name, Object value) {
		http.add(name, value);
		return this;
	}

	public CayteHttpTask addAll(Map<String, Object> params) {
		http.addAll(params);
		return this;
	}

	public CayteHttpTask set(Map<String, Object> params) {
		http.set(params);
		return this;
	}

	public CayteHttpTask clear() {
		http.clear();
		return this;
	}

	public CayteHttpTask content(String content) {
		http.content(content);
		return this;
	}

	public CayteHttpTask file(File file) {
		http.file(file);
		return this;
	}

	public CayteHttpTask download(String path) {
		http.download(path);
		return this;
	}

	public CayteHttpTask requestProgress(final CayteProgress requestProgress) {
		http.requestProgress(new CayteProgress() {

			@Override
			public void progress(long progress, long length, int state) {
				if (requestProgress != null)
					requestProgress.progress(progress, length, state);
				TaskProgress taskProgress = new TaskProgress();
				taskProgress.progress = progress;
				taskProgress.length = length;
				taskProgress.setInteger(state);
				publishProgress(taskProgress);
			}
		});
		return this;
	}

	public CayteHttpTask responseProgress(final CayteProgress responseProgress) {
		http.responseProgress(new CayteProgress() {

			@Override
			public void progress(long progress, long length, int state) {
				if (responseProgress != null)
					responseProgress.progress(progress, length, state);
				TaskProgress taskProgress = new TaskProgress();
				taskProgress.progress = progress;
				taskProgress.length = length;
				taskProgress.setInteger(state);
				publishProgress(taskProgress);
			}
		});
		return this;
	}

	@Override
	protected void onPreExecute() {
		super.onPreExecute();
		handler.PRE();
	}

	protected CayteResponse doHttp() {
		if (MODE == CayteHttpAsyncMode.DEFAULT)
			MODE = CayteHttp.DEFAULT_HTTP_MODE;
		switch (MODE) {
		case GET:
			return http.get().response();
		case POST:
			return http.post().response();
		case JSON:
			return http.postJson().response();
		case OCTET:
			return http.postOctet().response();
		case MULTIPART:
			return http.multipart().response();
		case UP_OCTET:
			return http.uploadOctet().response();
		case DEFAULT:
		default:
			return null;
		}
	}

	@Override
	protected TaskResult _doInBackground(Object... params) {
		TaskResult result = new TaskResult();
		CayteResponse response = doHttp();
		result.success = true;
		result.setInteger(response.code());
		result.setString(response.message());
		if (response.content() != null)
			result.setObject(response.content());
		else if (response.file() != null)
			result.setObject(response.file());
		else
			result.setObject(null);
		return result;
	}

	@Override
	protected void onProgressUpdate(TaskProgress... values) {
		for (int i = 0; i < values.length; i++) {
			if (handler != null && values[i] != null)
				handler.PROGRESS(values[i].progress, values[i].length, values[i].getInteger());
		}
	}

	@Override
	protected void onPostExecute(TaskResult result) {
		super.onPostExecute(result);
		handler.POST();
		handler.CALLBACK(result);
	}

	@Override
	protected void onCancelled() {
		super.onCancelled();
		handler.CANCEL();
	}

	public void cancel() {
		try {
			this.cancel(true);
			if (http != null)
				http.close();
			http = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
