package cayte.frame.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;

import okio.Buffer;

public final class CayteFormBuilder {

	private static final String contentType = "application/x-www-form-urlencoded";
	private final Buffer content = new Buffer();
	private String charsetName = CayteHttp.DEFAULT_CHARSETNAME;

	public CayteFormBuilder(String charsetName) {
		this.charsetName = charsetName;
	}

	public CayteFormBuilder add(String name, String value) throws UnsupportedEncodingException {
		if (content.size() > 0) {
			content.writeByte('&');
		}
		content.writeString(URLEncoder.encode(name, charsetName), Charset.forName(charsetName));
		content.writeByte('=');
		content.writeString(URLEncoder.encode(value, charsetName), Charset.forName(charsetName));
		return this;
	}

	public CayteFormBuilder addEncoded(String name, String value) {
		if (content.size() > 0) {
			content.writeByte('&');
		}
		content.writeString(name, Charset.forName(charsetName));
		content.writeByte('=');
		content.writeString(value, Charset.forName(charsetName));
		return this;
	}

	public RequestBody build() {
		return RequestBody.create(MediaType.parse(contentType + ";charset=" + charsetName),
				content.snapshot());
	}

}