/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteProgress;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class CayteResponseBody
extends ResponseBody {
    private ResponseBody responseBody = null;
    private CayteProgress responseProgress = null;
    private BufferedSource bufferedSource = null;
    private long contentLength = 0L;

    public static CayteResponseBody create(ResponseBody responseBody, CayteProgress responseProgress) {
        return new CayteResponseBody(responseBody, responseProgress);
    }

    public CayteResponseBody(ResponseBody responseBody, CayteProgress responseProgress) {
        this.responseBody = responseBody;
        this.responseProgress = responseProgress;
    }

    public long contentLength() throws IOException {
        return this.responseBody.contentLength();
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public BufferedSource source() throws IOException {
        if (this.bufferedSource == null) {
            this.contentLength = this.contentLength();
            if (this.responseProgress != null) {
                this.responseProgress.progress(0L, this.contentLength, -1);
            }
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                if (CayteResponseBody.this.responseProgress != null) {
                    CayteResponseBody.this.responseProgress.progress(this.totalBytesRead, CayteResponseBody.this.contentLength, bytesRead == -1L ? 1 : 0);
                }
                return bytesRead;
            }
        };
    }
}

