/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteHttp;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteResponseBody;
import cayte.frame.log.D;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CayteResponse {
    public static final int ERR_NETWORK = -1;
    public static final int ERR_SERVER = -2;
    public static final int ERR_EXCEPTION = -3;
    public static final int ERR_UNKNOW = -4;
    public static final int ERR_TIMEOUT = -5;
    private String charsetName = CayteHttp.DEFAULT_CHARSETNAME;
    private Response response = null;
    private int code = -1;
    private String message = null;
    private String content = null;
    private File file = null;
    private InputStream in = null;
    private OutputStream out = null;
    private FileThread fileThread;

    public static CayteResponse createError(int code, String message) {
        return new CayteResponse(code, message);
    }

    public static CayteResponse create(Response response, String charsetName) {
        return new CayteResponse(response, charsetName);
    }

    public CayteResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public CayteResponse(Response response, String charsetName) {
        this.response = response;
        this.charsetName = charsetName;
    }

    public Response response() {
        return this.response;
    }

    public boolean success() {
        return this.response != null && this.response.isSuccessful() && this.code == 200;
    }

    private void readStatus() {
        if (this.response == null) {
            this.code = -4;
            this.message = "error : unknown";
            return;
        }
        if (!this.response.isSuccessful()) {
            this.code = -2;
            this.message = "error : server";
            return;
        }
        this.code = this.response.code();
        this.message = this.response.message();
    }

    public CayteResponse read() {
        return this.read(null);
    }

    public CayteResponse read(CayteProgress responseProgress) {
        this.readStatus();
        if (this.success()) {
            try {
                ResponseBody responseBody = this.response.body();
                if (responseProgress != null) {
                    responseBody = CayteResponseBody.create(responseBody, responseProgress);
                }
                this.content = new String(responseBody.bytes(), this.charsetName);
            }
            catch (Exception e) {
                this.code = -3;
                this.message = "error : " + e.getLocalizedMessage();
                this.content = null;
                D.e((String)CayteHttp.TAG, (String)("content Exception : " + e.getMessage()), (Throwable)e);
            }
        }
        D.d((String)CayteHttp.TAG, (String)("response code : " + this.code));
        D.d((String)CayteHttp.TAG, (String)("response message : " + this.message));
        if (this.content != null) {
            D.d((String)CayteHttp.TAG, (String)("response content : " + this.content));
        } else {
            D.d((String)CayteHttp.TAG, (String)"response content : null");
        }
        return this;
    }

    public CayteResponse read(String path, CayteProgress responseProgress) {
        this.readStatus();
        if (this.success()) {
            try {
                ResponseBody responseBody = this.response.body();
                if (responseProgress != null) {
                    responseBody = CayteResponseBody.create(responseBody, responseProgress);
                }
                this.file = this.readFile(path, responseBody);
                if (this.file == null) {
                    this.code = -1;
                    this.message = "error : network";
                }
            }
            catch (Exception e) {
                this.code = -3;
                this.message = "error : " + e.getLocalizedMessage();
                this.file = null;
                D.e((String)CayteHttp.TAG, (String)("file Exception : " + e.getMessage()), (Throwable)e);
            }
        }
        D.d((String)CayteHttp.TAG, (String)("response code : " + this.code));
        D.d((String)CayteHttp.TAG, (String)("response message : " + this.message));
        if (this.file != null) {
            D.d((String)CayteHttp.TAG, (String)("response file : " + this.file.getAbsolutePath()));
        } else {
            D.d((String)CayteHttp.TAG, (String)"response file : null");
        }
        return this;
    }

    public int code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public String content() {
        return this.content;
    }

    public File file() {
        return this.file;
    }

    private File readFile(String path, ResponseBody responseBody) throws Exception {
        this.in = responseBody.byteStream();
        File tempFile = new File(path + ".temp");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        tempFile.createNewFile();
        this.out = new FileOutputStream(tempFile);
        this.fileThread = new FileThread();
        this.fileThread.start();
        this.fileThread.join();
        if (this.fileThread.isInterrupted() || this.fileThread.isException()) {
            this.clearFile(path);
            return null;
        }
        File file = new File(path);
        tempFile.renameTo(file);
        return file;
    }

    private void interruptThread() {
        if (this.fileThread != null && this.fileThread.getState() != Thread.State.TERMINATED) {
            this.fileThread.interrupt();
        }
    }

    private void clearFile(String path) {
        new File(path + ".temp").delete();
        new File(path).delete();
    }

    public void close() {
        this.interruptThread();
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class FileThread
    extends Thread {
        private boolean isException = false;

        private FileThread() {
        }

        @Override
        public void run() {
            try {
                byte[] buffer = new byte[8192];
                int n = 0;
                while (!this.isInterrupted() && (n = CayteResponse.this.in.read(buffer)) != -1) {
                    CayteResponse.this.out.write(buffer, 0, n);
                    CayteResponse.this.out.flush();
                }
            }
            catch (Exception e) {
                this.isException = true;
            }
            finally {
                CayteResponse.this.close();
            }
        }

        public boolean isException() {
            return this.isException;
        }
    }
}

