/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.http;

import cayte.frame.http.CayteFormBuilder;
import cayte.frame.http.CayteProgress;
import cayte.frame.http.CayteRequestBody;
import cayte.frame.http.CayteResponse;
import cayte.frame.http.async.CayteHttpAsyncMode;
import cayte.frame.log.D;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CayteHttp {
    public static final String TAG = CayteHttp.class.getSimpleName();
    public static int DEFAULT_CONNECTTIMEOUT = 5;
    public static int DEFAULT_WRITETIMEOUT = 15;
    public static int DEFAULT_READTIMEOUT = 15;
    public static String DEFAULT_CHARSETNAME = "utf-8";
    public static boolean DEFAULT_RETRY_FAIL = false;
    public static boolean DEFAULT_POST_ENCODED = false;
    public static CayteHttpAsyncMode DEFAULT_HTTP_MODE = CayteHttpAsyncMode.POST;
    public static CookieManager DEFAULT_COOKIE_MANAGER = null;
    private OkHttpClient client = null;
    private String url = null;
    private int connectTimeout = DEFAULT_CONNECTTIMEOUT;
    private int writeTimeout = DEFAULT_WRITETIMEOUT;
    private int readTimeout = DEFAULT_READTIMEOUT;
    private String requestCharsetName = DEFAULT_CHARSETNAME;
    private String responseCharsetName = DEFAULT_CHARSETNAME;
    private boolean retryOnFail = DEFAULT_RETRY_FAIL;
    private boolean postEncoded = DEFAULT_POST_ENCODED;
    private CookieManager cookieManager = DEFAULT_COOKIE_MANAGER;
    private Map<String, Object> params = new HashMap<String, Object>();
    private String content = null;
    private File file = null;
    private String path = null;
    private Request request = null;
    private CayteProgress requestProgress;
    private Object tag = null;
    private Response response = null;
    private CayteProgress responseProgress;
    private CayteResponse cayteResponse = null;
    private CookieHandler session = null;
    private Throwable e = null;

    public static CayteHttp create() {
        return new CayteHttp();
    }

    public CayteHttp() {
        D.i((String)TAG, (String)"connect create");
    }

    public CayteHttp url(String url) {
        this.url = url;
        D.i((String)TAG, (String)("connect url : " + url.toString()));
        return this;
    }

    public CayteHttp connectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
        D.i((String)TAG, (String)("client connectTimeout : " + connectTimeout));
        return this;
    }

    public CayteHttp writeTimeout(int writeTimeout) {
        if (writeTimeout > 0) {
            this.writeTimeout = writeTimeout;
        }
        D.i((String)TAG, (String)("client writeTimeout : " + writeTimeout));
        return this;
    }

    public CayteHttp readTimeout(int readTimeout) {
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
        D.i((String)TAG, (String)("client readTimeout : " + readTimeout));
        return this;
    }

    public CayteHttp requestCharsetName(String requestCharsetName) {
        this.requestCharsetName = requestCharsetName;
        D.i((String)TAG, (String)("client requestCharsetName : " + requestCharsetName));
        return this;
    }

    public CayteHttp responseCharsetName(String responseCharsetName) {
        this.responseCharsetName = responseCharsetName;
        D.i((String)TAG, (String)("client responseCharsetName : " + responseCharsetName));
        return this;
    }

    public CayteHttp retryOnFail(boolean retryOnFail) {
        this.retryOnFail = retryOnFail;
        D.i((String)TAG, (String)("client retryOnFail : " + retryOnFail));
        return this;
    }

    public CayteHttp postEncoded(boolean postEncoded) {
        this.postEncoded = postEncoded;
        D.i((String)TAG, (String)("client postEncoded : " + postEncoded));
        return this;
    }

    public CayteHttp cookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        D.i((String)TAG, (String)"client cookieManager");
        return this;
    }

    public CayteHttp requestProgress(CayteProgress requestProgress) {
        this.requestProgress = requestProgress;
        return this;
    }

    public CayteHttp responseProgress(CayteProgress responseProgress) {
        this.responseProgress = responseProgress;
        return this;
    }

    private void createClient() {
        this.client = new OkHttpClient();
        this.client.setConnectTimeout((long)this.connectTimeout, TimeUnit.SECONDS);
        this.client.setWriteTimeout((long)this.writeTimeout, TimeUnit.SECONDS);
        this.client.setReadTimeout((long)this.readTimeout, TimeUnit.SECONDS);
        this.client.setRetryOnConnectionFailure(this.retryOnFail);
        if (this.cookieManager != null) {
            this.client.setCookieHandler((CookieHandler)this.cookieManager);
        }
        this.tag = String.valueOf(System.currentTimeMillis());
    }

    public void close() {
        this.close(null);
    }

    public void close(Throwable e) {
        this.e = e;
        if (this.cayteResponse != null) {
            this.cayteResponse.close();
        }
        if (this.client != null && this.tag != null) {
            this.client.cancel(this.tag);
        }
        this.client = null;
    }

    private void doRequest() throws Exception {
        this.setSession2Connection();
        this.response = this.client.newCall(this.request).execute();
    }

    public CayteHttp get() {
        D.i((String)TAG, (String)"get");
        try {
            this.createClient();
            this.request = new Request.Builder().url(this.url).tag(this.tag).build();
            this.doRequest();
            D.i((String)TAG, (String)"get finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("get Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public CayteHttp add(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public CayteHttp addAll(Map<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    public CayteHttp set(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public CayteHttp clear() {
        this.params.clear();
        return this;
    }

    public CayteHttp content(String content) {
        this.content = content;
        return this;
    }

    public CayteHttp file(File file) {
        this.file = file;
        return this;
    }

    public CayteHttp post() {
        D.i((String)TAG, (String)"post");
        try {
            CayteFormBuilder formBuilder = new CayteFormBuilder(this.requestCharsetName);
            if (this.params != null && !this.params.isEmpty()) {
                for (String key : this.params.keySet()) {
                    Object object = this.params.get(key);
                    if (object == null || object instanceof File) continue;
                    D.d((String)TAG, (String)("params :" + key + "=" + object.toString()));
                    if (this.postEncoded) {
                        formBuilder.addEncoded(key, object.toString());
                        continue;
                    }
                    formBuilder.add(key, object.toString());
                }
            }
            RequestBody body = formBuilder.build();
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).post(body).tag(this.tag).build();
            this.doRequest();
            D.i((String)TAG, (String)"post finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("post Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp post(String contentType) {
        D.i((String)TAG, (String)("request : " + contentType));
        try {
            D.d((String)TAG, (String)("content :" + this.content.toString()));
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)(contentType.toString() + ";charset=" + this.requestCharsetName)), (String)this.content);
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).post(body).tag(this.tag).build();
            this.doRequest();
            D.i((String)TAG, (String)"request finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("request Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp upload(String contentType) {
        D.i((String)TAG, (String)("request : " + contentType));
        try {
            D.d((String)TAG, (String)("file :" + this.file.getAbsolutePath()));
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)contentType.toString()), (File)this.file);
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).post(body).tag(this.tag).build();
            this.doRequest();
            D.i((String)TAG, (String)"request finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("request Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    public CayteHttp multipart() {
        D.i((String)TAG, (String)"multipart");
        try {
            MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM);
            if (this.params != null && !this.params.isEmpty()) {
                for (String key : this.params.keySet()) {
                    Object object = this.params.get(key);
                    if (object == null) continue;
                    if (object instanceof File) {
                        File file = (File)object;
                        D.d((String)TAG, (String)("params :" + key + "=" + file.getAbsolutePath()));
                        MediaType mediaType = MediaType.parse((String)CayteHttp.getMimeType4URLConnection(file.getAbsolutePath()));
                        builder.addFormDataPart(key, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
                        continue;
                    }
                    String content = object.toString();
                    D.d((String)TAG, (String)("params :" + key + "=" + content));
                    if (!this.postEncoded) {
                        content = URLEncoder.encode(content, this.requestCharsetName);
                    }
                    builder.addFormDataPart(key, content);
                }
            }
            RequestBody body = builder.build();
            if (this.requestProgress != null) {
                body = CayteRequestBody.create(body, this.requestProgress);
            }
            this.createClient();
            this.request = new Request.Builder().url(this.url).post(body).tag(this.tag).build();
            this.doRequest();
            D.i((String)TAG, (String)"multipart finish");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("multipart Exception : " + e.getMessage()), (Throwable)e);
            this.close(e);
        }
        return this;
    }

    private CookieHandler getSession4Connection() {
        if (this.client != null) {
            return this.client.getCookieHandler();
        }
        return null;
    }

    private void setSession2Connection() {
        if (this.client != null && this.session != null) {
            this.client.setCookieHandler(this.session);
        }
    }

    public CookieHandler getSession() {
        return this.session;
    }

    public void setSession(CookieHandler session) {
        this.session = session;
    }

    public CayteHttp download(String path) {
        this.path = path;
        return this;
    }

    public CayteResponse response() {
        try {
            if (this.client == null) {
                this.cayteResponse = this.e == null ? CayteResponse.createError(-4, "error : unknow") : (this.e instanceof ConnectException || this.e instanceof UnknownHostException ? CayteResponse.createError(-1, "error : network") : (this.e instanceof InterruptedIOException ? CayteResponse.createError(-5, "error : timeout") : CayteResponse.createError(-3, "error : " + this.e.getLocalizedMessage())));
                CayteResponse cayteResponse = this.cayteResponse;
                return cayteResponse;
            }
            this.session = this.getSession4Connection();
            this.cayteResponse = this.path == null ? CayteResponse.create(this.response, this.responseCharsetName).read(this.responseProgress) : CayteResponse.create(this.response, this.responseCharsetName).read(this.path, this.responseProgress);
            D.i((String)TAG, (String)"response");
        }
        catch (Exception e) {
            D.e((String)TAG, (String)("response Exception : " + e.getMessage()), (Throwable)e);
            this.cayteResponse = CayteResponse.createError(-3, "error : " + e.getLocalizedMessage());
        }
        finally {
            this.close();
        }
        return this.cayteResponse;
    }

    public static String decoding(String encode, String fromCharsetName, String toCharsetName) {
        try {
            return new String(encode.getBytes(fromCharsetName), toCharsetName);
        }
        catch (Exception e) {
            return encode;
        }
    }

    public static String getMimeType4URLConnection(String path) {
        try {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String type = fileNameMap.getContentTypeFor(path);
            if (type == null) {
                return "application/octet-stream";
            }
            return type;
        }
        catch (Exception e) {
            return "application/octet-stream";
        }
    }

    public CayteHttp postOctet() {
        return this.post("application/octet-stream");
    }

    public CayteHttp postJson() {
        return this.post("application/json");
    }

    public CayteHttp uploadOctet() {
        return this.upload("application/octet-stream");
    }
}

