package cayte.frame.http;

import java.io.IOException;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;

import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class CayteRequestBody extends RequestBody {

	private RequestBody requestBody;
	private CayteProgress requestProgress;
	private BufferedSink bufferedSink;
	private long contentLength = 0L;

	public static CayteRequestBody create(RequestBody requestBody, CayteProgress requestProgress) {
		return new CayteRequestBody(requestBody, requestProgress);
	}

	public CayteRequestBody(RequestBody requestBody, CayteProgress requestProgress) {
		this.requestBody = requestBody;
		this.requestProgress = requestProgress;
	}

	@Override
	public MediaType contentType() {
		return requestBody.contentType();
	}

	@Override
	public long contentLength() throws IOException {
		return requestBody.contentLength();
	}

	@Override
	public void writeTo(BufferedSink sink) throws IOException {
		if (bufferedSink == null) {
			contentLength = contentLength();
			if (requestProgress != null)
				requestProgress.progress(0, contentLength, -1);
			bufferedSink = Okio.buffer(sink(sink));
		}
		requestBody.writeTo(bufferedSink);
		bufferedSink.flush();
	}

	private Sink sink(Sink sink) {
		return new ForwardingSink(sink) {
			long bytesWritten = 0L;

			@Override
			public void write(Buffer source, long byteCount) throws IOException {
				super.write(source, byteCount);
				bytesWritten += byteCount;
				if (requestProgress != null)
					requestProgress.progress(bytesWritten, contentLength, bytesWritten == contentLength ? 1 : 0);
			}
		};
	}

}