/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.util;

import android.annotation.SuppressLint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class CalendarUtils {
    public static int firstDayOfWeek = 1;

    @SuppressLint(value={"SimpleDateFormat"})
    public static DateFormat getDateFormat(String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat;
    }

    public static void printCalendar(String tag, Calendar c) {
        System.out.println(tag + ">>>" + c.get(1) + "-" + c.get(2) + "-" + c.get(5));
    }

    public static Calendar getTodayCalendar() {
        Calendar calendar = CalendarUtils.getCalendar(System.currentTimeMillis());
        return calendar;
    }

    public static Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setFirstDayOfWeek(firstDayOfWeek);
        return calendar;
    }

    public static Calendar getCalendar(long timeInMillis) {
        Calendar calendar = CalendarUtils.getCalendar();
        return CalendarUtils.setTimeInMillis(calendar, timeInMillis);
    }

    public static Calendar getCalendar(int year, int month, int day) {
        Calendar calendar = CalendarUtils.getCalendar();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar;
    }

    public static Calendar setTimeInMillis(Calendar calendar, long timeInMillis) {
        calendar.setTimeInMillis(timeInMillis);
        return CalendarUtils.clearTime(calendar);
    }

    public static Calendar clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar getMonthCalendar(int index, long timeInMillis) {
        Calendar calendar = CalendarUtils.getCalendar(timeInMillis);
        calendar.add(2, index);
        return calendar;
    }

    public static Calendar getWeekCalendar(int index, long timeInMillis) {
        Calendar calendar = CalendarUtils.getCalendar(timeInMillis);
        calendar.add(3, index);
        return calendar;
    }

    public static Calendar copyCalendar(Calendar calendar) {
        return CalendarUtils.getCalendar(calendar.getTimeInMillis());
    }

    public static boolean sameDay(Calendar c1, Calendar c2) {
        return c1 != null && c2 != null && c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static boolean sameDay(Calendar c, int year, int month, int day) {
        return c != null && c.get(1) == year && c.get(2) == month && c.get(5) == day;
    }

    public static int getDiffMonth4Calendar(long initTime, Calendar day) {
        Calendar calendarFirst = CalendarUtils.getCalendar(initTime);
        calendarFirst.set(5, 1);
        Calendar calendar = CalendarUtils.copyCalendar(day);
        calendar.set(5, 1);
        int index = 0;
        if (calendar.compareTo(calendarFirst) < 0) {
            while (calendar.compareTo(calendarFirst) < 0) {
                --index;
                calendar.add(2, 1);
            }
        } else {
            while (calendar.compareTo(calendarFirst) > 0) {
                ++index;
                calendar.add(2, -1);
            }
        }
        return index;
    }

    public static int getDiffWeek4Calendar(long initTime, Calendar day) {
        Calendar calendarFirst = CalendarUtils.getCalendar(initTime);
        calendarFirst.add(7, firstDayOfWeek - calendarFirst.get(7));
        Calendar calendar = CalendarUtils.copyCalendar(day);
        calendar.add(7, firstDayOfWeek - calendar.get(7));
        int index = 0;
        if (calendar.compareTo(calendarFirst) < 0) {
            while (calendar.compareTo(calendarFirst) < 0) {
                --index;
                calendar.add(3, 1);
            }
        } else {
            while (calendar.compareTo(calendarFirst) > 0) {
                ++index;
                calendar.add(3, -1);
            }
        }
        return index;
    }
}

