/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.List;

public class AppUtils {
    public static boolean isAndroid40() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static boolean isAndroid44() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean isAndroid50() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isAndroid60() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static int getVersionCode(Context con) {
        try {
            PackageManager manager = con.getApplicationContext().getPackageManager();
            PackageInfo info = manager.getPackageInfo(con.getPackageName(), 0);
            return info.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getVersionName(Context con) {
        try {
            PackageManager manager = con.getApplicationContext().getPackageManager();
            PackageInfo info = manager.getPackageInfo(con.getPackageName(), 0);
            return info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0.0";
        }
    }

    public static boolean isAppOnForeground(Context con) {
        ActivityManager activityManager = (ActivityManager)con.getSystemService("activity");
        String packageName = con.getPackageName();
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(packageName) || appProcess.importance != 100) continue;
            return true;
        }
        return false;
    }
}

