/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.ui;

import android.app.Activity;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import cayte.frame.act.ActivityStack;
import cayte.frame.act.OverridePendingTransition;
import cayte.frame.helper.MobileParams;
import cayte.frame.manager.IsRefreshManager;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskManager;
import cayte.frame.ui.UIInterface;

public class UIActivity<T extends Activity, E extends UIInterface> {
    public LayoutInflater inflater = null;
    public E ai;
    public TaskManager taskManager = null;
    protected T a;

    public UIActivity(T a, E ai) {
        this.a = a;
        this.ai = ai;
    }

    public T getA() {
        return this.a;
    }

    public void overrideIn() {
        OverridePendingTransition.overrideInPendingTransition(this.a, this.ai.overridePendingTransition());
    }

    public void overrideOut() {
        OverridePendingTransition.overrideOutPendingTransition(this.a, this.ai.overridePendingTransition());
    }

    public void onCreate() {
        MobileParams.newInstance(this.a);
        this.taskManager = new TaskManager();
        this.inflater = (LayoutInflater)this.a.getSystemService("layout_inflater");
    }

    public void onResume() {
        String action = IsRefreshManager.instance().get(this.a.getClass());
        if (!TextUtils.isEmpty((CharSequence)action)) {
            this.ai.refresh(action, new Object[0]);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        MobileParams.newInstance(this.a);
    }

    public void onDestroy() {
        this.cancelAllTask();
        this.taskManager = null;
        this.inflater = null;
    }

    public void pushActivity() {
        ActivityStack.instance().pushActivity((Activity)this.a, 0);
    }

    public void pushActivity(int flag) {
        ActivityStack.instance().pushActivity((Activity)this.a, flag);
    }

    public void popActivity() {
        ActivityStack.instance().popActivity((Activity)this.a);
    }

    public void setVisibility(int visible, View ... views) {
        for (View v : views) {
            v.setVisibility(visible);
        }
    }

    public void setClickListener(View.OnClickListener click, View ... views) {
        for (View v : views) {
            v.setOnClickListener(click);
        }
    }

    public <Params> void execute(GenericTask<Params> genericTask) {
        this.taskManager.execute(genericTask);
    }

    public void cancelAllTask() {
        this.taskManager.cancelAll();
    }
}

