/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.task;

import cayte.frame.task.TaskListener;
import cayte.frame.task.TaskProgress;
import cayte.frame.task.TaskResult;
import java.util.Observable;
import java.util.Observer;

public abstract class GenericThread<T>
extends Thread
implements Observer {
    protected TaskListener mListener = null;
    protected boolean isCancelable = false;
    protected T[] params = null;

    public GenericThread(T ... params) {
        this.params = params;
    }

    protected abstract TaskResult _doInBackground(T ... var1);

    public void setListener(TaskListener taskListener) {
        this.mListener = taskListener;
    }

    public TaskListener getListener() {
        return this.mListener;
    }

    protected void onCancelled() {
        try {
            if (this.mListener != null) {
                this.mListener.onCancelled();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPreExecute() {
        try {
            if (this.mListener != null) {
                this.mListener.onPreExecute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void start() {
        this.onPreExecute();
        super.start();
    }

    @Override
    public void run() {
        TaskResult result = this._doInBackground(this.params);
        if (this.isCancelable && this.isInterrupted()) {
            this.onCancelled();
        } else {
            this.onPostExecute(result);
        }
    }

    public void publishProgress(TaskProgress ... values) {
        this.onProgressUpdate(values);
    }

    protected void onProgressUpdate(TaskProgress ... values) {
        try {
            if (this.mListener != null && values != null && values.length > 0) {
                this.mListener.onProgressUpdate(values);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onPostExecute(TaskResult result) {
        try {
            if (this.mListener != null) {
                this.mListener.onPostExecute(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancel() {
        this.isCancelable = true;
        if (!this.isInterrupted()) {
            this.interrupt();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (0 == (Integer)arg && !this.isCancelable) {
            this.cancel();
        }
    }
}

