/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

@SuppressLint(value={"SimpleDateFormat"})
public class ApplicationCrashHelper
implements Thread.UncaughtExceptionHandler {
    private OnUncaughtException onUncaught = null;
    private static ApplicationCrashHelper instance;
    private Context context;
    private DateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private ApplicationCrashHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationCrashHelper instance() {
        if (instance != null) return instance;
        Class<ApplicationCrashHelper> clazz = ApplicationCrashHelper.class;
        synchronized (ApplicationCrashHelper.class) {
            if (instance != null) return instance;
            instance = new ApplicationCrashHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context, OnUncaughtException onUncaught) {
        this.context = context.getApplicationContext();
        this.onUncaught = onUncaught;
    }

    @Override
    public void uncaughtException(Thread arg0, Throwable arg1) {
        String versioninfo = this.getVersionInfo();
        String mobileInfo = this.getMobileInfo();
        String errorinfo = this.getErrorInfo(arg1);
        try {
            if (this.onUncaught != null) {
                this.onUncaught.onUncaughtException(this.dataFormat.format(new Date()), versioninfo, mobileInfo, errorinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getErrorInfo(Throwable arg1) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        arg1.printStackTrace(pw);
        pw.close();
        String error = ((Object)writer).toString();
        return error;
    }

    private String getMobileInfo() {
        StringBuffer sb = new StringBuffer();
        try {
            Field[] fields;
            for (Field field : fields = Build.class.getDeclaredFields()) {
                field.setAccessible(true);
                String name = field.getName();
                String value = field.get(null).toString();
                sb.append(name + "=" + value);
                sb.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String getVersionInfo() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo info = pm.getPackageInfo(this.context.getPackageName(), 0);
            return "versionCode : " + info.versionCode + "   versionName : " + info.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Version unknown!";
        }
    }

    public static interface OnUncaughtException {
        public void onUncaughtException(String ... var1);
    }
}

