/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.file;

import cayte.frame.file.FileUtils;
import java.io.File;
import java.util.ArrayList;

public class FolderUtils {
    public static void createFolder(String ... paths) {
        for (String path : paths) {
            FolderUtils.checkFolder(path);
        }
    }

    public static boolean checkFolder(String path) {
        try {
            File dir = new File(path);
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    return true;
                }
                dir.delete();
                return FolderUtils.checkFolder(path);
            }
            if (FolderUtils.checkFolder(dir.getParent())) {
                return dir.mkdir();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void deleteFile(String path) {
        try {
            File file;
            if (path != null && !path.equals("") && (file = new File(path)).exists()) {
                if (file.isFile()) {
                    file.delete();
                } else {
                    File[] fl = file.listFiles();
                    if (fl != null && fl.length > 0) {
                        for (File f : fl) {
                            FolderUtils.deleteFile(f.getAbsolutePath());
                        }
                    }
                    if (file != null) {
                        file.delete();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String path, String ... outPath) {
        try {
            File file;
            ArrayList<String> outs = new ArrayList<String>();
            if (outPath != null) {
                for (int i = 0; i < outPath.length; ++i) {
                    outs.add(outPath[i]);
                }
            }
            if (path != null && !path.equals("") && (file = new File(path)).exists() && !outs.contains(file.getAbsolutePath())) {
                if (file.isFile()) {
                    file.delete();
                } else {
                    File[] fl = file.listFiles();
                    if (fl != null && fl.length > 0) {
                        for (File f : fl) {
                            FolderUtils.deleteFile(f.getAbsolutePath(), outPath);
                        }
                    }
                    if (file != null) {
                        file.delete();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String fromPath, String toPath) {
        try {
            if (fromPath != null && !fromPath.equals("") && toPath != null && !toPath.equals("")) {
                File from = new File(fromPath);
                File to = new File(toPath);
                if (from.exists()) {
                    if (from.isFile()) {
                        FileUtils.fileChannelCopy(from, to);
                    } else if (from.isDirectory()) {
                        to.mkdirs();
                        File[] fl = from.listFiles();
                        if (fl != null && fl.length > 0) {
                            for (File f : fl) {
                                FolderUtils.copyFile(f.getPath(), toPath + File.separator + f.getName());
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

