/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import cayte.frame.adapter.RecycleViewHolder;
import cayte.frame.task.GenericTask;
import cayte.frame.ui.UIInterface;
import java.util.ArrayList;
import java.util.List;

public abstract class RecycleViewAdapter<T, E extends RecycleViewHolder>
extends RecyclerView.Adapter {
    protected List<T> datas = new ArrayList<T>();
    protected Activity act = null;
    protected LayoutInflater inflater = null;

    public RecycleViewAdapter(Activity act) {
        this.act = act;
        this.inflater = LayoutInflater.from((Context)act);
    }

    public RecycleViewAdapter(LayoutInflater inflater) {
        this.inflater = inflater;
    }

    protected abstract int getLayoutResourceId(int var1);

    protected abstract E createViewHolder(View var1, int var2);

    protected abstract void _onCreateViewHolder(E var1, int var2);

    protected abstract void _onBindViewHolder(E var1, T var2, int var3);

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutResourceId(viewType), parent, false);
        E viewHolder = this.createViewHolder(view, viewType);
        this._onCreateViewHolder(viewHolder, viewType);
        return viewHolder;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        RecycleViewHolder viewHolder = (RecycleViewHolder)holder;
        viewHolder.setPostion(position);
        this._onBindViewHolder(viewHolder, this.getItem(position), position);
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        if (datas == null) {
            return;
        }
        this.datas = datas;
    }

    public void clear() {
        this.datas.clear();
    }

    public int getItemCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public T getItem(int position) {
        return this.datas.get(position);
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public T getFirstItem() {
        if (this.isEmpty()) {
            return null;
        }
        return this.datas.get(0);
    }

    public T getLastItem() {
        if (this.isEmpty()) {
            return null;
        }
        return this.datas.get(this.datas.size() - 1);
    }

    public <T> void execute(GenericTask<T> genericTask) {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().execute(genericTask);
        } else {
            genericTask.execute(new Object[0]);
        }
    }

    public <T> void execute(GenericTask<T> genericTask, T ... params) {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().taskManager.execute(genericTask, params);
        } else {
            genericTask.execute(params);
        }
    }

    public void cancelAllTask() {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().cancelAllTask();
        }
    }
}

