/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import cayte.frame.task.GenericTask;
import cayte.frame.ui.UIInterface;
import java.util.ArrayList;
import java.util.List;

public abstract class ListAdapter<T>
extends BaseAdapter {
    protected List<T> datas = new ArrayList<T>();
    protected Activity act = null;
    protected LayoutInflater inflater = null;

    public ListAdapter(Activity act) {
        this.act = act;
        this.inflater = LayoutInflater.from((Context)act);
    }

    public ListAdapter(LayoutInflater inflater) {
        this.inflater = inflater;
    }

    public List<T> getDatas() {
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        if (datas == null) {
            return;
        }
        this.datas = datas;
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.datas.clear();
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.datas == null ? 0 : this.datas.size();
    }

    public T getItem(int position) {
        return this.datas.get(position);
    }

    public T getFirstItem() {
        if (this.isEmpty()) {
            return null;
        }
        return this.datas.get(0);
    }

    public T getLastItem() {
        if (this.isEmpty()) {
            return null;
        }
        return this.datas.get(this.datas.size() - 1);
    }

    public long getItemId(int position) {
        return position;
    }

    public <Params> void execute(GenericTask<Params> genericTask) {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().execute(genericTask);
        } else {
            genericTask.execute(new Object[0]);
        }
    }

    public <Params> void execute(GenericTask<Params> genericTask, Params ... params) {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().taskManager.execute(genericTask, params);
        } else {
            genericTask.execute(params);
        }
    }

    public void cancelAllTask() {
        if (this.act != null && this.act instanceof UIInterface) {
            ((UIInterface)this.act).getUIActivity().cancelAllTask();
        }
    }
}

