/*
 * Decompiled with CFR 0.152.
 */
package cayte.frame.act;

import android.app.Activity;
import cayte.frame.log.D;
import java.util.Stack;

public class ActivityStack {
    private static final String TAG = ActivityStack.class.getCanonicalName();
    private static Stack<Activity> activityStack;
    private static ActivityStack instance;

    private ActivityStack() {
        activityStack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityStack instance() {
        if (instance != null) return instance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (instance != null) return instance;
            instance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void popActivity() {
        Activity activity = activityStack.pop();
        D.d(TAG, "pop activity-->" + activity.getClass().getCanonicalName());
        if (activity != null) {
            activity.finish();
            activity = null;
        }
    }

    public void popActivity(Activity activity) {
        D.d(TAG, "pop activity-->" + activity.getClass().getCanonicalName());
        if (activity != null && this.equalsActivity(activity, this.currentActivity())) {
            activity.finish();
            activityStack.pop();
            activity = null;
        }
    }

    public void popToActivity(Class<?> cls) {
        Activity activity = null;
        while ((activity = this.currentActivity()) != null && !activity.getClass().equals(cls)) {
            this.popActivity();
        }
    }

    public String currentActivityName() {
        if (activityStack.isEmpty()) {
            return "";
        }
        Activity activity = (Activity)activityStack.lastElement();
        String currentName = activity.getClass().getCanonicalName();
        activity = null;
        return currentName;
    }

    public Activity currentActivity() {
        if (activityStack.isEmpty()) {
            return null;
        }
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public void pushActivity(Activity activity, int flag) {
        String actName = activity.getClass().getCanonicalName();
        D.d(TAG, "push activity-->" + actName);
        switch (flag) {
            default: {
                break;
            }
            case 1: {
                String str;
                if (!this.Contains(actName)) break;
                Activity act = null;
                do {
                    act = activityStack.pop();
                    str = act.getClass().getCanonicalName();
                    act.finish();
                    act = null;
                } while (!actName.equals(str));
                break;
            }
            case 2: {
                Activity act = null;
                do {
                    act = activityStack.pop();
                    act.finish();
                    act = null;
                } while (activityStack.size() != 1);
                break;
            }
        }
        activityStack.add(activity);
    }

    public void popAllActivity() {
        D.d(TAG, "---pop all activity---");
        while (this.currentActivity() != null) {
            this.popActivity();
        }
    }

    public void popToTop() {
        D.d(TAG, "---pop to top activity---");
        while (activityStack.size() > 1) {
            this.popActivity();
        }
    }

    public boolean Contains(Activity activity) {
        String actName = activity.getClass().getCanonicalName();
        return this.Contains(actName);
    }

    public boolean Contains(String actName) {
        for (Activity act : activityStack) {
            if (!actName.equalsIgnoreCase(act.getClass().getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public boolean equalsActivity(Activity act1, Activity act2) {
        if (act1 == null || act2 == null) {
            return false;
        }
        return act1.getClass().getCanonicalName().equalsIgnoreCase(act2.getClass().getCanonicalName());
    }

    public boolean equalsActivity(Activity act1, String act2) {
        if (act1 == null) {
            return false;
        }
        return act1.getClass().getCanonicalName().equalsIgnoreCase(act2);
    }

    public <T> T getActivityByName(String activity) {
        if (ActivityStack.instance().currentActivity().getClass().getCanonicalName().equalsIgnoreCase(activity)) {
            return (T)ActivityStack.instance().currentActivity();
        }
        return null;
    }
}

