package cayte.frame.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;

import cayte.frame.manager.IsRefreshManager;
import cayte.frame.task.GenericTask;
import cayte.frame.task.TaskManager;

public class UIFragment<T extends Fragment, E extends UIFragmentInterface> {

    /**
     * LayoutInflater
     */
    public LayoutInflater inflater = null;
    /**
     * UI需要实现的相关接口
     */
    public E ai;
    /**
     * 可调用到所在Activity的onFragment(int type, Object... params)
     */
    public UITabInterface onFragmentListener = null;
    /**
     * Task管理
     */
    public TaskManager taskManager = null;
    /**
     * T extends Fragment
     */
    protected T a;

    /**
     * 实例化
     *
     * @param a  a extends Fragment
     * @param ai ai implements UIInterface
     */
    public UIFragment(T a, E ai) {
        this.a = a;
        this.ai = ai;
        this.onFragmentListener = (UITabInterface) a.getActivity();
    }

    /**
     * 获取Fragment所在的Activity实例
     *
     * @return TabActivity
     */
    public Activity getA() {
        return a.getActivity();
    }

    /**
     * 获取 T extends Fragment 实例
     *
     * @return T extends Fragment
     */
    public T getF() {
        return a;
    }

    /**
     * 在super.onCreate后调用<br>
     * 初始化taskManager,inflater
     */
    public void onCreate() {
        taskManager = new TaskManager();
        inflater = (LayoutInflater) a.getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    /**
     * 在super.onResume后调用<br>
     * ai.refresh(IsRefreshManager.instance().get(a.getClass()));
     */
    public void onResume() {
        ai.refresh(IsRefreshManager.instance().get(a.getClass()));
    }

    /**
     * 在super.onDestroy后调用<br>
     * 取消所有Task<br>
     * 销毁对象taskManager,inflater
     */
    public void onDestroy() {
        cancelAllTask();
        taskManager = null;
        inflater = null;
    }

    /**
     * 在super.onHiddenChanged后调用<br>
     *
     * @param hidden 传入onHiddenChanged参数
     */
    public void onHiddenChanged(boolean hidden) {
        if (hidden) {
            // 出界面
            ai.onHideFragment();
        } else {
            // 进界面
            ai.refresh(IsRefreshManager.instance().get(a.getClass()));
            ai.onShowFragment();
        }
    }


    /**
     * 集合设置是否可见,setVisibility
     *
     * @param visible like View.VISIBLE
     * @param views   View...
     */
    public void setVisibility(int visible, View... views) {
        for (View v : views) {
            v.setVisibility(visible);
        }
    }

    /**
     * 集合设置点击事件,setOnClickListener
     *
     * @param click 点击事件View.OnClickListener
     * @param views View...
     */
    public void setClickListener(View.OnClickListener click, View... views) {
        for (View v : views) {
            v.setOnClickListener(click);
        }
    }

    /**
     * 执行线程并加入到TaskManager中
     *
     * @param genericTask GenericTask
     * @param <Params>    参数泛型
     */
    public <Params> void execute(GenericTask<Params> genericTask) {
        taskManager.execute(genericTask);
    }

    /**
     * 取消TaskManager中所有线程(只能取消回调,不能中断线程)
     */
    public void cancelAllTask() {
        taskManager.cancelAll();
    }

}
