package cayte.frame.toast;

import android.content.Context;
import android.widget.Toast;

public class ToastBuild {

	private Context context;
	private CharSequence text;
	private int duration = Toast.LENGTH_SHORT;

	public static ToastBuild with(Context context) {
		return new ToastBuild(context);
	}

	public ToastBuild(Context context) {
		this.context = context;
	}

	public ToastBuild text(CharSequence text) {
		this.text = text;
		return this;
	}

	public ToastBuild text(int text) {
		return text(context.getString(text));
	}

	public ToastBuild duration(int duration) {
		this.duration = duration;
		return this;
	}

	public ToastBuild SHORT() {
		this.duration = Toast.LENGTH_SHORT;
		return this;
	}

	public ToastBuild LONG() {
		this.duration = Toast.LENGTH_LONG;
		return this;
	}

	public Toast build() {
		return Toast.makeText(context, text, duration);
	}

	public void show() {
		build().show();
	}

}
